/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.keycloak;

import io.smallrye.mutiny.Uni;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Map;

final class KeycloakDevServicesUtils {
    private static final byte AMP = 38;
    private static final byte EQ = 61;

    private KeycloakDevServicesUtils() {
    }

    static WebClient createWebClient(Vertx vertx) {
        WebClientOptions options = new WebClientOptions();
        options.setTrustAll(true);
        options.setVerifyHost(false);
        return WebClient.create((io.vertx.mutiny.core.Vertx)new io.vertx.mutiny.core.Vertx(vertx), (WebClientOptions)options);
    }

    static Uni<String> getPasswordAccessToken(WebClient client, String tokenUrl, String clientId, String clientSecret, String userName, String userPassword, Map<String, String> passwordGrantOptions) {
        HttpRequest request = client.postAbs(tokenUrl);
        request.putHeader(HttpHeaders.CONTENT_TYPE.toString(), HttpHeaders.APPLICATION_X_WWW_FORM_URLENCODED.toString());
        io.vertx.mutiny.core.MultiMap props = new io.vertx.mutiny.core.MultiMap(MultiMap.caseInsensitiveMultiMap());
        props.add("client_id", clientId);
        if (clientSecret != null) {
            props.add("client_secret", clientSecret);
        }
        props.add("username", userName);
        props.add("password", userPassword);
        props.add("grant_type", "password");
        if (passwordGrantOptions != null) {
            props.addAll(passwordGrantOptions);
        }
        return request.sendBuffer(KeycloakDevServicesUtils.encodeForm(props)).onItem().transform(KeycloakDevServicesUtils::getAccessTokenFromJson).onFailure().retry().withBackOff(Duration.ofSeconds(2L), Duration.ofSeconds(2L)).expireIn(10000L);
    }

    private static String getAccessTokenFromJson(HttpResponse<Buffer> resp) {
        if (resp.statusCode() == 200) {
            JsonObject json = resp.bodyAsJsonObject();
            return json.getString("access_token");
        }
        String errorMessage = resp.bodyAsString();
        throw new RuntimeException(errorMessage);
    }

    private static Buffer encodeForm(io.vertx.mutiny.core.MultiMap form) {
        Buffer buffer = Buffer.buffer();
        for (Map.Entry entry : form) {
            if (buffer.length() != 0) {
                buffer.appendByte((byte)38);
            }
            buffer.appendString((String)entry.getKey());
            buffer.appendByte((byte)61);
            buffer.appendString(KeycloakDevServicesUtils.urlEncode((String)entry.getValue()));
        }
        return buffer;
    }

    private static String urlEncode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

