/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import java.io.Serializable;

public class ArtifactKey
implements Serializable {
    protected final String groupId;
    protected final String artifactId;
    protected final String classifier;
    protected final String type;

    public static ArtifactKey fromString(String str) {
        return new ArtifactKey(ArtifactKey.split(str, new String[4], str.length()));
    }

    protected static String[] split(String str, String[] parts, int fromIndex) {
        int i = str.lastIndexOf(58, fromIndex - 1);
        if (i <= 0) {
            throw new IllegalArgumentException("GroupId and artifactId separating ':' is absent or not in the right place in '" + str.substring(0, fromIndex) + "'");
        }
        parts[3] = str.substring(i + 1, fromIndex);
        fromIndex = i;
        if ((i = str.lastIndexOf(58, fromIndex - 1)) < 0) {
            parts[0] = str.substring(0, fromIndex);
            parts[1] = parts[3];
            if (parts[1].isEmpty()) {
                throw new IllegalArgumentException("ArtifactId is empty in `" + str + "`");
            }
            parts[2] = "";
            parts[3] = null;
            return parts;
        }
        if (i == 0) {
            throw new IllegalArgumentException("One of groupId or artifactId is missing from '" + str.substring(0, fromIndex) + "'");
        }
        parts[2] = i == fromIndex - 1 ? "" : str.substring(i + 1, fromIndex);
        fromIndex = i;
        if ((i = str.lastIndexOf(58, fromIndex - 1)) < 0) {
            parts[0] = str.substring(0, fromIndex);
            parts[1] = parts[2];
            if (parts[1].isEmpty()) {
                throw new IllegalArgumentException("ArtifactId is empty in `" + str + "`");
            }
            parts[2] = parts[3];
            parts[3] = null;
            return parts;
        }
        if (i == 0 || i == fromIndex - 1) {
            throw new IllegalArgumentException("One of groupId or artifactId is missing from '" + str.substring(0, fromIndex) + "'");
        }
        parts[0] = str.substring(0, i);
        parts[1] = str.substring(i + 1, fromIndex);
        if (parts[3].isEmpty()) {
            parts[3] = null;
        }
        return parts;
    }

    public ArtifactKey(String[] parts) {
        this.groupId = parts[0];
        this.artifactId = parts[1];
        this.classifier = parts.length == 2 || parts[2] == null ? "" : parts[2];
        this.type = parts.length <= 3 || parts[3] == null ? "jar" : parts[3];
    }

    public ArtifactKey(String groupId, String artifactId) {
        this(groupId, artifactId, null);
    }

    public ArtifactKey(String groupId, String artifactId, String classifier) {
        this(groupId, artifactId, classifier, null);
    }

    public ArtifactKey(String groupId, String artifactId, String classifier, String type) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classifier = classifier == null ? "" : classifier;
        this.type = type;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getType() {
        return this.type;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArtifactKey other = (ArtifactKey)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        if (!this.classifier.isEmpty()) {
            buf.append(':').append(this.classifier);
        } else if (this.type != null) {
            buf.append(':');
        }
        if (this.type != null) {
            buf.append(':').append(this.type);
        }
        return buf.toString();
    }

    public String toGacString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.groupId).append(':').append(this.artifactId);
        if (!this.classifier.isEmpty()) {
            buf.append(':').append(this.classifier);
        }
        return buf.toString();
    }
}

