/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.core.strategy;

import io.fabric8.maven.Maven;
import io.fabric8.maven.XMLFormat;
import io.fabric8.maven.merge.SmartModelMerger;
import io.quarkus.devtools.codestarts.CodestartException;
import io.quarkus.devtools.codestarts.core.CodestartData;
import io.quarkus.devtools.codestarts.core.reader.TargetFile;
import io.quarkus.devtools.codestarts.core.strategy.CodestartFileStrategyHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Path;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.model.Model;

final class SmartPomMergeCodestartFileStrategyHandler
implements CodestartFileStrategyHandler {
    SmartPomMergeCodestartFileStrategyHandler() {
    }

    @Override
    public String name() {
        return "smart-pom-merge";
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<TargetFile> codestartFiles, Map<String, Object> data) throws IOException {
        this.checkNotEmptyCodestartFiles(codestartFiles);
        Path targetPath = targetDirectory.resolve(relativePath);
        this.checkTargetDoesNotExist(targetPath);
        this.createDirectories(targetPath);
        CodestartData.getBuildtool(data).filter(b -> Objects.equals(b, "maven")).orElseThrow(() -> new CodestartException("something is wrong, smart-pom-merge file strategy must only be used on maven projects"));
        SmartModelMerger merger = new SmartModelMerger();
        Model targetModel = Maven.readModel((Reader)new StringReader(codestartFiles.get(0).getContent()));
        ListIterator<TargetFile> iterator = codestartFiles.listIterator(1);
        while (iterator.hasNext()) {
            merger.merge(targetModel, Maven.readModel((Reader)new StringReader(iterator.next().getContent())), true, null);
        }
        Maven.writeModel((Model)targetModel, (Path)targetPath, (XMLFormat)XMLFormat.builder().indent("    ").insertLineBreakBetweenMajorSections().build());
    }
}

