/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.quarkus;

import io.quarkus.devtools.codestarts.CodestartProjectInputBuilder;
import io.quarkus.devtools.codestarts.DataKey;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartCatalog;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartProjectInput;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class QuarkusCodestartProjectInputBuilder
extends CodestartProjectInputBuilder {
    private static final List<QuarkusCodestartCatalog.AppContent> FULL_CONTENT = Arrays.asList(QuarkusCodestartCatalog.AppContent.values());
    Collection<ArtifactCoords> extensions = new ArrayList<ArtifactCoords>();
    Collection<ArtifactCoords> platforms = new ArrayList<ArtifactCoords>();
    Set<QuarkusCodestartCatalog.AppContent> appContent = new HashSet<QuarkusCodestartCatalog.AppContent>(FULL_CONTENT);
    String example;
    BuildTool buildTool = BuildTool.MAVEN;

    QuarkusCodestartProjectInputBuilder() {
    }

    public QuarkusCodestartProjectInputBuilder addExtensions(Collection<ArtifactCoords> extensions) {
        this.extensions.addAll(extensions);
        super.addDependencies((Collection)extensions.stream().map(Extensions::toGAV).collect(Collectors.toList()));
        return this;
    }

    public QuarkusCodestartProjectInputBuilder addExtension(ArtifactCoords extension) {
        return this.addExtensions(Collections.singletonList(extension));
    }

    public QuarkusCodestartProjectInputBuilder addExtension(ArtifactKey extension) {
        return this.addExtension(Extensions.toCoords(extension, null));
    }

    public QuarkusCodestartProjectInputBuilder addPlatforms(Collection<ArtifactCoords> boms) {
        this.platforms.addAll(boms);
        super.addBoms((Collection)boms.stream().map(Extensions::toGAV).collect(Collectors.toList()));
        return this;
    }

    public QuarkusCodestartProjectInputBuilder example(String example) {
        this.example = example;
        return this;
    }

    public QuarkusCodestartProjectInputBuilder addCodestarts(Collection<String> codestarts) {
        super.addCodestarts(codestarts);
        return this;
    }

    public QuarkusCodestartProjectInputBuilder addCodestart(String codestart) {
        super.addCodestart(codestart);
        return this;
    }

    public QuarkusCodestartProjectInputBuilder addData(Map<String, Object> data) {
        super.addData(data);
        return this;
    }

    public QuarkusCodestartProjectInputBuilder addBoms(Collection<String> boms) {
        super.addBoms(boms);
        return this;
    }

    public QuarkusCodestartProjectInputBuilder putData(String key, Object value) {
        super.putData(key, value);
        return this;
    }

    public QuarkusCodestartProjectInputBuilder putData(DataKey key, Object value) {
        super.putData(key, value);
        return this;
    }

    public QuarkusCodestartProjectInputBuilder messageWriter(MessageWriter messageWriter) {
        super.messageWriter(messageWriter);
        return this;
    }

    public QuarkusCodestartProjectInputBuilder noCode() {
        return this.noCode(true);
    }

    public QuarkusCodestartProjectInputBuilder noCode(boolean noCode) {
        if (noCode) {
            this.appContent.remove((Object)QuarkusCodestartCatalog.AppContent.CODE);
        } else {
            this.appContent.add(QuarkusCodestartCatalog.AppContent.CODE);
        }
        return this;
    }

    public QuarkusCodestartProjectInputBuilder noDockerfiles() {
        return this.noDockerfiles(true);
    }

    public QuarkusCodestartProjectInputBuilder noDockerfiles(boolean noDockerfiles) {
        if (noDockerfiles) {
            this.appContent.remove((Object)QuarkusCodestartCatalog.AppContent.DOCKERFILES);
        } else {
            this.appContent.add(QuarkusCodestartCatalog.AppContent.DOCKERFILES);
        }
        return this;
    }

    public QuarkusCodestartProjectInputBuilder noBuildToolWrapper() {
        return this.noBuildToolWrapper(true);
    }

    public QuarkusCodestartProjectInputBuilder noBuildToolWrapper(boolean noBuildToolWrapper) {
        if (noBuildToolWrapper) {
            this.appContent.remove((Object)QuarkusCodestartCatalog.AppContent.BUILD_TOOL_WRAPPER);
        } else {
            this.appContent.add(QuarkusCodestartCatalog.AppContent.BUILD_TOOL_WRAPPER);
        }
        return this;
    }

    public QuarkusCodestartProjectInputBuilder buildTool(BuildTool buildTool) {
        if (buildTool == null) {
            return this;
        }
        this.buildTool = buildTool;
        return this;
    }

    public QuarkusCodestartProjectInput build() {
        return new QuarkusCodestartProjectInput(this);
    }
}

