/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.buildfile;

import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.devtools.project.buildfile.AbstractGradleBuildFilesCreator;
import io.quarkus.devtools.project.buildfile.AbstractGroovyGradleBuildFile;
import io.quarkus.maven.ArtifactCoords;
import java.io.IOException;

public final class GroovyGradleBuildFilesCreator
extends AbstractGradleBuildFilesCreator {
    public GroovyGradleBuildFilesCreator(QuarkusProject quarkusProject) {
        super(quarkusProject);
    }

    @Override
    String getSettingsGradlePath() {
        return "settings.gradle";
    }

    @Override
    String getBuildGradlePath() {
        return "build.gradle";
    }

    @Override
    void createBuildContent(String groupId, String version) throws IOException {
        String versionLine;
        String groupLine;
        ArtifactCoords bom;
        String buildContent = this.getModel().getBuildContent();
        StringBuilder res = new StringBuilder(buildContent);
        if (!buildContent.contains("id 'io.quarkus'")) {
            res.append("plugins {");
            res.append(System.lineSeparator()).append("    id 'java'").append(System.lineSeparator());
            res.append(System.lineSeparator()).append("    id 'io.quarkus'").append(System.lineSeparator());
            res.append("}");
        }
        if (!this.containsBOM((bom = this.getQuarkusProject().getExtensionsCatalog().getBom()).getGroupId(), bom.getArtifactId())) {
            res.append(System.lineSeparator());
            res.append("dependencies {").append(System.lineSeparator());
            res.append("    implementation enforcedPlatform(\"${quarkusPlatformGroupId}:${quarkusPlatformArtifactId}:${quarkusPlatformVersion}\")").append(System.lineSeparator());
            res.append("    implementation 'io.quarkus:quarkus-resteasy'").append(System.lineSeparator());
            res.append("    testImplementation 'io.quarkus:quarkus-junit5'").append(System.lineSeparator());
            res.append("    testImplementation 'io.rest-assured:rest-assured'").append(System.lineSeparator());
            res.append("}").append(System.lineSeparator());
        }
        if (!buildContent.contains(groupLine = "group '" + groupId + "'")) {
            res.append(System.lineSeparator()).append(groupLine).append(System.lineSeparator());
        }
        if (!buildContent.contains(versionLine = "version '" + version + "'")) {
            res.append(System.lineSeparator()).append(versionLine).append(System.lineSeparator());
        }
        res.append(System.lineSeparator()).append("test {").append(System.lineSeparator()).append("    systemProperty \"java.util.logging.manager\", \"org.jboss.logmanager.LogManager\"").append(System.lineSeparator()).append("}");
        this.getModel().setBuildContent(res.toString());
    }

    @Override
    void createSettingsContent(String artifactId) throws IOException {
        String settingsContent = this.getModel().getSettingsContent();
        StringBuilder res = new StringBuilder();
        if (!settingsContent.contains("id 'io.quarkus'")) {
            res.append(System.lineSeparator());
            res.append("pluginManagement {").append(System.lineSeparator());
            res.append("    repositories {").append(System.lineSeparator());
            res.append("        mavenLocal()").append(System.lineSeparator());
            res.append("        mavenCentral()").append(System.lineSeparator());
            res.append("        gradlePluginPortal()").append(System.lineSeparator());
            res.append("    }").append(System.lineSeparator());
            res.append("    plugins {").append(System.lineSeparator());
            res.append("        id 'io.quarkus' version \"${quarkusPluginVersion}\"").append(System.lineSeparator());
            res.append("    }").append(System.lineSeparator());
            res.append("}").append(System.lineSeparator());
        }
        if (!settingsContent.contains("rootProject.name")) {
            res.append(System.lineSeparator()).append("rootProject.name='").append(artifactId).append("'").append(System.lineSeparator());
        }
        res.append(settingsContent);
        this.getModel().setSettingsContent(res.toString());
    }

    @Override
    void addDependencyInBuildFile(ArtifactCoords coords) throws IOException {
        AbstractGroovyGradleBuildFile.addDependencyInModel(this.getModel(), coords, false);
    }
}

