/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.platform.catalog.processor;

import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.platform.catalog.processor.MetadataValue;
import io.quarkus.platform.catalog.processor.ProcessedCategory;
import io.quarkus.registry.catalog.Category;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class CatalogProcessor {
    private static final String CODESTART_ARTIFACTS = "codestarts-artifacts";
    private final ExtensionCatalog catalog;

    private CatalogProcessor(ExtensionCatalog catalog) {
        this.catalog = Objects.requireNonNull(catalog);
    }

    public static CatalogProcessor of(ExtensionCatalog catalog) {
        return new CatalogProcessor(catalog);
    }

    public static List<ProcessedCategory> getProcessedCategoriesInOrder(ExtensionCatalog catalog) {
        HashMap extsByCategory = new HashMap(catalog.getCategories().size());
        for (Extension e : catalog.getExtensions()) {
            List<String> categories = ExtensionProcessor.of(e).getCategories();
            for (String c : categories) {
                if (!extsByCategory.containsKey(c)) {
                    extsByCategory.put(c, new ArrayList());
                }
                ((List)extsByCategory.get(c)).add(e);
            }
        }
        ArrayList<ProcessedCategory> orderedCategories = new ArrayList<ProcessedCategory>(catalog.getCategories().size());
        for (Category c : catalog.getCategories()) {
            if (!extsByCategory.containsKey(c.getId())) continue;
            orderedCategories.add(new ProcessedCategory(c, (Collection)extsByCategory.get(c.getId())));
        }
        return orderedCategories;
    }

    public static List<String> getCodestartArtifacts(ExtensionCatalog catalog) {
        return CatalogProcessor.getMetadataValue(catalog, CODESTART_ARTIFACTS).asStringList();
    }

    public ExtensionCatalog getCatalog() {
        return this.catalog;
    }

    public List<String> getCodestartArtifacts() {
        return CatalogProcessor.getCodestartArtifacts(this.catalog);
    }

    public List<ProcessedCategory> getProcessedCategoriesInOrder() {
        return CatalogProcessor.getProcessedCategoriesInOrder(this.catalog);
    }

    public static MetadataValue getMetadataValue(ExtensionCatalog catalog, String path) {
        return MetadataValue.get(catalog.getMetadata(), path);
    }
}

