/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.codegen.writer;

import io.quarkus.devtools.project.codegen.writer.ProjectWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class FileProjectWriter
implements ProjectWriter {
    private final File root;

    public FileProjectWriter(File file) {
        this.root = file;
    }

    @Override
    public void init() throws IOException {
        if (!this.root.exists()) {
            boolean mkdirStatus = this.root.mkdirs();
            if (!mkdirStatus) {
                throw new IOException("Failed to create root directory");
            }
            return;
        }
        if (!this.root.isDirectory()) {
            throw new IOException("Project root needs to be a directory");
        }
        String[] files = this.root.list();
        if (files != null && files.length > 0) {
            throw new IOException("You can't create a project when the folder is not empty.");
        }
    }

    @Override
    public String mkdirs(String path) {
        File dirToCreate = new File(this.root, path);
        if (!dirToCreate.exists()) {
            dirToCreate.mkdirs();
        }
        if (path.isEmpty()) {
            return "";
        }
        return dirToCreate.getPath().substring(this.root.getPath().length() + 1);
    }

    @Override
    public void write(String path, String content) throws IOException {
        Path outputPath = this.root.toPath().resolve(path);
        Files.write(outputPath, content.getBytes("UTF-8"), new OpenOption[0]);
    }

    @Override
    public byte[] getContent(String path) throws IOException {
        return Files.readAllBytes(this.root.toPath().resolve(path));
    }

    @Override
    public boolean exists(String path) {
        return new File(this.root, path).exists();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public File getProjectFolder() {
        return this.root;
    }

    @Override
    public boolean hasFile() {
        return true;
    }
}

