/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project.extensions;

import io.quarkus.devtools.project.BuildTool;
import io.quarkus.devtools.project.extensions.ExtensionInstallPlan;
import io.quarkus.maven.ArtifactCoords;
import io.quarkus.maven.ArtifactKey;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;

public interface ExtensionManager {
    public BuildTool getBuildTool();

    public Collection<ArtifactCoords> getInstalledPlatforms() throws IOException;

    public Collection<ArtifactCoords> getInstalled() throws IOException;

    default public boolean isInstalled(ArtifactKey key) throws IOException {
        return this.getInstalled().stream().anyMatch(i -> Objects.equals(i.getKey(), key));
    }

    public InstallResult install(Collection<ArtifactCoords> var1) throws IOException;

    public InstallResult install(ExtensionInstallPlan var1) throws IOException;

    public UninstallResult uninstall(Collection<ArtifactKey> var1) throws IOException;

    public static class UninstallResult {
        private final Collection<ArtifactKey> uninstalled;

        public UninstallResult(Collection<ArtifactKey> uninstalled) {
            this.uninstalled = uninstalled;
        }

        public Collection<ArtifactKey> getUninstalled() {
            return this.uninstalled;
        }

        public boolean isSourceUpdated() {
            return this.uninstalled.size() > 0;
        }
    }

    public static class InstallResult {
        private final Collection<ArtifactCoords> installedPlatforms;
        private final Collection<ArtifactCoords> installedManagedExtensions;
        private final Collection<ArtifactCoords> installedIndependentExtensions;
        private final Collection<ArtifactKey> alreadyInstalled;

        public InstallResult(Collection<ArtifactCoords> installedPlatforms, Collection<ArtifactCoords> installedManagedExtensions, Collection<ArtifactCoords> installedIndependentExtensions, Collection<ArtifactKey> alreadyInstalled) {
            this.installedPlatforms = installedPlatforms;
            this.installedManagedExtensions = installedManagedExtensions;
            this.installedIndependentExtensions = installedIndependentExtensions;
            this.alreadyInstalled = alreadyInstalled;
        }

        public Collection<ArtifactCoords> getInstalledManagedExtensions() {
            return this.installedManagedExtensions;
        }

        public Collection<ArtifactCoords> getInstalledIndependentExtensions() {
            return this.installedIndependentExtensions;
        }

        public Collection<ArtifactCoords> getInstalledPlatforms() {
            return this.installedPlatforms;
        }

        public Collection<ArtifactKey> getAlreadyInstalled() {
            return this.alreadyInstalled;
        }

        public boolean isSourceUpdated() {
            return !this.installedPlatforms.isEmpty() || !this.installedManagedExtensions.isEmpty() || !this.installedIndependentExtensions.isEmpty();
        }
    }
}

