/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.project;

import io.quarkus.devtools.project.SourceType;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class JavaVersion {
    public static final JavaVersion NA = new JavaVersion();
    private final String version;
    public static final SortedSet<Integer> JAVA_VERSIONS_LTS = new TreeSet<Integer>(List.of(Integer.valueOf(11), Integer.valueOf(17), Integer.valueOf(21)));
    public static final int DEFAULT_JAVA_VERSION = 17;
    public static final String DEFAULT_JAVA_VERSION_FOR_EXTENSION = "17";
    public static final int MAX_LTS_SUPPORTED_BY_KOTLIN = 21;
    public static final String DETECT_JAVA_RUNTIME_VERSION = "<<detect java runtime version>>";
    public static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("(\\d+)(?:\\..*)?");

    private JavaVersion() {
        this(null);
    }

    public JavaVersion(String version) {
        this.version = version;
    }

    public boolean isEmpty() {
        return this.version == null;
    }

    public boolean isPresent() {
        return this.version != null;
    }

    public String getVersion() {
        return this.version;
    }

    public int getAsInt() {
        if (this.version == null) {
            throw new IllegalStateException("Version is not available and can't be parsed as an integer.");
        }
        return Integer.parseInt(this.version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaVersion that = (JavaVersion)o;
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.version);
    }

    public String toString() {
        return this.isEmpty() ? "NA" : this.version;
    }

    public static int determineBestJavaLtsVersion() {
        return JavaVersion.determineBestJavaLtsVersion(Runtime.version().feature());
    }

    public static SortedSet<Integer> getCompatibleLTSVersions(JavaVersion minimumJavaVersion) {
        if (minimumJavaVersion.isEmpty()) {
            return JAVA_VERSIONS_LTS;
        }
        return JAVA_VERSIONS_LTS.stream().filter(v -> v >= minimumJavaVersion.getAsInt()).collect(Collectors.toCollection(TreeSet::new));
    }

    public static int determineBestJavaLtsVersion(int runtimeVersion) {
        int ltsVersion;
        int bestLtsVersion = 17;
        Iterator iterator = JAVA_VERSIONS_LTS.iterator();
        while (iterator.hasNext() && (ltsVersion = ((Integer)iterator.next()).intValue()) <= runtimeVersion) {
            bestLtsVersion = ltsVersion;
        }
        return bestLtsVersion;
    }

    public static String computeJavaVersion(SourceType sourceType, String inputJavaVersion) {
        Matcher matcher;
        Integer javaFeatureVersionTarget = null;
        if (inputJavaVersion != null && !DETECT_JAVA_RUNTIME_VERSION.equals(inputJavaVersion) && (matcher = JAVA_VERSION_PATTERN.matcher(inputJavaVersion)).matches()) {
            javaFeatureVersionTarget = Integer.valueOf(matcher.group(1));
        }
        if (javaFeatureVersionTarget == null) {
            javaFeatureVersionTarget = Runtime.version().feature();
        }
        int bestJavaLtsVersion = JavaVersion.determineBestJavaLtsVersion(javaFeatureVersionTarget);
        if (SourceType.KOTLIN.equals((Object)sourceType) && bestJavaLtsVersion > 21) {
            bestJavaLtsVersion = 21;
        }
        return String.valueOf(bestJavaLtsVersion);
    }
}

