/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.codestarts.jbang.QuarkusJBangCodestartCatalog;
import io.quarkus.devtools.codestarts.jbang.QuarkusJBangCodestartProjectInput;
import io.quarkus.devtools.codestarts.jbang.QuarkusJBangCodestartProjectInputBuilder;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartData;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.CreateProjectCodestartDataConverter;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CreateJBangProjectCommandHandler
implements QuarkusCommandHandler {
    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Set<String> extensionsQuery = invocation.getValue("project.extensions", Collections.emptySet());
        List<ArtifactCoords> extensionsToAdd = QuarkusCommandHandlers.computeCoordsFromQuery(invocation, extensionsQuery);
        if (extensionsToAdd == null) {
            throw new QuarkusCommandException("Failed to create project because of invalid extensions");
        }
        ExtensionCatalog catalog = invocation.getExtensionsCatalog();
        boolean noWrapper = invocation.getValue("codegen.no-jbang-wrapper", false) || invocation.getValue("codegen.no-buildtool-wrapper", false);
        QuarkusJBangCodestartProjectInputBuilder builder = QuarkusJBangCodestartProjectInput.builder().addExtensions(extensionsToAdd).setNoJBangWrapper(noWrapper).addData((Map)CreateProjectCodestartDataConverter.toCodestartData(invocation.getValues())).putData(QuarkusCodestartData.QuarkusDataKey.QUARKUS_VERSION, (Object)invocation.getExtensionsCatalog().getQuarkusCoreVersion());
        if (catalog.getBom() != null) {
            ArtifactCoords firstBom = catalog.getBom();
            builder.putData(QuarkusJBangCodestartCatalog.JBangDataKey.QUARKUS_BOM_GROUP_ID.key(), (Object)firstBom.getGroupId()).putData(QuarkusJBangCodestartCatalog.JBangDataKey.QUARKUS_BOM_ARTIFACT_ID.key(), (Object)firstBom.getArtifactId()).putData(QuarkusJBangCodestartCatalog.JBangDataKey.QUARKUS_BOM_VERSION.key(), (Object)firstBom.getVersion());
        }
        QuarkusJBangCodestartProjectInput input = builder.build();
        Path projectDir = invocation.getQuarkusProject().getProjectDirPath();
        try {
            invocation.log().info("-----------");
            if (!extensionsToAdd.isEmpty()) {
                invocation.log().info("selected extensions: \n" + extensionsToAdd.stream().map(e -> "- " + e.getGroupId() + ":" + e.getArtifactId() + "\n").collect(Collectors.joining()));
            }
            this.getCatalog(invocation.getQuarkusProject()).createProject(input).generate(projectDir);
            invocation.log().info("\n-----------\n" + MessageIcons.SUCCESS_ICON + "  jbang project has been successfully generated in:\n--> " + invocation.getQuarkusProject().getProjectDirPath().toString() + "\n-----------");
        }
        catch (IOException e2) {
            throw new QuarkusCommandException("Failed to create JBang project: " + e2.getMessage(), e2);
        }
        return QuarkusCommandOutcome.success();
    }

    private QuarkusJBangCodestartCatalog getCatalog(QuarkusProject project) throws IOException {
        return QuarkusJBangCodestartCatalog.fromResourceLoaders(project.getCodestartResourceLoaders());
    }
}

