/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.messagewriter;

import io.smallrye.common.os.OS;

public enum MessageIcons {
    UP_TO_DATE_ICON(MessageIcons.toEmoji("U+2714"), "v"),
    OUT_OF_DATE_ICON(MessageIcons.toEmoji("U+26A0"), "x"),
    SUCCESS_ICON(MessageIcons.toEmoji("U+2705"), "[SUCCESS]"),
    FAILURE_ICON(MessageIcons.toEmoji("U+274C"), "[FAILURE]"),
    NOOP_ICON(MessageIcons.toEmoji("U+1F44D"), ""),
    WARN_ICON(MessageIcons.toEmoji("U+1F525"), "[WARN]"),
    ERROR_ICON(MessageIcons.toEmoji("U+2757"), "[ERROR]");

    private String icon;
    private String messageCode;

    private MessageIcons(String icon, String messageCode) {
        this.icon = icon;
        this.messageCode = messageCode;
    }

    public static String toEmoji(String text) {
        String[] codes = text.replace("U+", "0x").split(" ");
        StringBuilder stringBuilder = new StringBuilder();
        for (String code : codes) {
            Integer intCode = Integer.decode(code.trim());
            char[] cArray = Character.toChars(intCode);
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                Character character = Character.valueOf(cArray[i]);
                stringBuilder.append(character);
            }
        }
        return stringBuilder.toString();
    }

    public String iconOrMessage() {
        return OS.WINDOWS.isCurrent() ? this.messageCode : this.icon;
    }

    public String toString() {
        return OS.WINDOWS.isCurrent() ? String.format("%s ", this.messageCode) : String.format("%s %s ", this.messageCode, this.icon);
    }
}

