/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.quarkus.registry.catalog.CatalogMapperHelper;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalogImpl;
import io.quarkus.registry.json.JsonBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;

public interface PlatformCatalog {
    public Collection<Platform> getPlatforms();

    public Map<String, Object> getMetadata();

    public Platform getPlatform(String var1);

    @JsonIgnore
    default public Platform getRecommendedPlatform() {
        Collection<Platform> platforms = this.getPlatforms();
        return platforms.isEmpty() ? null : platforms.iterator().next();
    }

    default public Mutable mutable() {
        return new PlatformCatalogImpl.Builder(this);
    }

    default public void persist(Path p) throws IOException {
        CatalogMapperHelper.serialize((Object)this, p);
    }

    public static Mutable builder() {
        return new PlatformCatalogImpl.Builder();
    }

    public static PlatformCatalog fromFile(Path path) throws IOException {
        return PlatformCatalog.mutableFromFile(path).build();
    }

    public static Mutable mutableFromFile(Path path) throws IOException {
        Mutable mutable = CatalogMapperHelper.deserialize(path, PlatformCatalogImpl.Builder.class);
        return mutable == null ? PlatformCatalog.builder() : mutable;
    }

    public static interface Mutable
    extends PlatformCatalog,
    JsonBuilder<PlatformCatalog> {
        public Mutable addPlatform(Platform var1);

        public Mutable setPlatforms(Collection<Platform> var1);

        public Mutable setMetadata(Map<String, Object> var1);

        public Mutable setMetadata(String var1, Object var2);

        public Mutable removeMetadata(String var1);

        @Override
        public PlatformCatalog build();

        @Override
        default public void persist(Path p) throws IOException {
            CatalogMapperHelper.serialize((Object)this.build(), p);
        }
    }
}

