/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.catalog.Category;
import io.quarkus.registry.catalog.CategoryImpl;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionImpl;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.ExtensionOriginImpl;
import io.quarkus.registry.json.JsonBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"id", "platform", "bom", "quarkus-core-version", "upstream-quarkus-core-version", "extensions", "categories", "metadata"})
public class ExtensionCatalogImpl
extends ExtensionOriginImpl
implements ExtensionCatalog {
    private final String quarkusCoreVersion;
    private final String upstreamQuarkusCoreVersion;
    private final List<ExtensionOrigin> derivedFrom;
    private final List<Extension> extensions;
    private final List<Category> categories;

    private ExtensionCatalogImpl(Builder builder, List<Extension> extensions) {
        super(builder);
        this.quarkusCoreVersion = builder.quarkusCoreVersion;
        this.upstreamQuarkusCoreVersion = builder.upstreamQuarkusCoreVersion;
        this.derivedFrom = JsonBuilder.buildersToUnmodifiableList(builder.derivedFrom);
        this.extensions = extensions;
        this.categories = JsonBuilder.buildersToUnmodifiableList(builder.categories);
    }

    @Override
    public String getQuarkusCoreVersion() {
        return this.quarkusCoreVersion;
    }

    @Override
    public String getUpstreamQuarkusCoreVersion() {
        return this.upstreamQuarkusCoreVersion;
    }

    @Override
    public List<ExtensionOrigin> getDerivedFrom() {
        return this.derivedFrom;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    @Override
    public List<Category> getCategories() {
        return this.categories;
    }

    public static class Builder
    extends ExtensionOriginImpl.Builder
    implements ExtensionCatalog.Mutable {
        private String quarkusCoreVersion;
        private String upstreamQuarkusCoreVersion;
        private List<ExtensionOrigin> derivedFrom;
        private List<Extension> extensions;
        private List<Category> categories;

        public Builder() {
        }

        Builder(ExtensionCatalog source) {
            super(source);
            this.quarkusCoreVersion = source.getQuarkusCoreVersion();
            this.upstreamQuarkusCoreVersion = source.getUpstreamQuarkusCoreVersion();
            this.derivedFrom = JsonBuilder.modifiableListOrNull(source.getDerivedFrom());
            this.extensions = JsonBuilder.modifiableListOrNull(source.getExtensions());
            this.categories = JsonBuilder.modifiableListOrNull(source.getCategories());
        }

        @Override
        public Builder setId(String id) {
            super.setId(id);
            return this;
        }

        @Override
        public Builder setPlatform(boolean platform) {
            super.setPlatform(platform);
            return this;
        }

        @Override
        public Builder setBom(ArtifactCoords bom) {
            super.setBom(bom);
            return this;
        }

        @Override
        public String getQuarkusCoreVersion() {
            return this.quarkusCoreVersion;
        }

        @Override
        public Builder setQuarkusCoreVersion(String quarkusCoreVersion) {
            this.quarkusCoreVersion = quarkusCoreVersion;
            return this;
        }

        @Override
        public String getUpstreamQuarkusCoreVersion() {
            return this.upstreamQuarkusCoreVersion;
        }

        @Override
        public Builder setUpstreamQuarkusCoreVersion(String upstreamQuarkusCoreVersion) {
            this.upstreamQuarkusCoreVersion = upstreamQuarkusCoreVersion;
            return this;
        }

        @Override
        public List<ExtensionOrigin> getDerivedFrom() {
            return this.derivedFrom == null ? Collections.emptyList() : this.derivedFrom;
        }

        @Override
        @JsonDeserialize(contentAs=ExtensionOriginImpl.Builder.class)
        public Builder setDerivedFrom(List<ExtensionOrigin> origins) {
            this.derivedFrom = JsonBuilder.modifiableListOrNull(origins);
            return this;
        }

        public List<Extension> getExtensions() {
            return this.extensions == null ? Collections.emptyList() : this.extensions;
        }

        @Override
        @JsonDeserialize(contentAs=ExtensionImpl.Builder.class)
        public Builder setExtensions(List<Extension> extensions) {
            this.extensions = JsonBuilder.modifiableListOrNull(extensions);
            return this;
        }

        @Override
        public Builder addExtension(Extension e) {
            if (this.extensions == null) {
                this.extensions = new ArrayList<Extension>();
            }
            this.extensions.add(e);
            return this;
        }

        @Override
        public List<Category> getCategories() {
            return this.categories == null ? Collections.emptyList() : this.categories;
        }

        @Override
        @JsonDeserialize(contentAs=CategoryImpl.Builder.class)
        public Builder setCategories(List<Category> categories) {
            this.categories = JsonBuilder.modifiableListOrNull(categories);
            return this;
        }

        @Override
        public Builder addCategory(Category c) {
            if (this.categories == null) {
                this.categories = new ArrayList<Category>();
            }
            this.categories.add(c);
            return this;
        }

        @Override
        public Builder setMetadata(Map<String, Object> newValues) {
            super.setMetadata((Map)newValues);
            return this;
        }

        @Override
        @JsonIgnore
        public Builder setMetadata(String key, Object value) {
            super.setMetadata(key, value);
            return this;
        }

        @Override
        public Builder removeMetadata(String key) {
            super.removeMetadata(key);
            return this;
        }

        @Override
        public ExtensionCatalogImpl build() {
            List<Extension> built = JsonBuilder.buildersToUnmodifiableList(this.extensions);
            return new ExtensionCatalogImpl(this, built);
        }
    }
}

