/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import io.quarkus.registry.config.RegistriesConfigMapperHelper;
import io.quarkus.registry.config.RegistryConfigImpl;
import io.quarkus.registry.config.RegistryDescriptorConfig;
import io.quarkus.registry.config.RegistryMavenConfig;
import io.quarkus.registry.config.RegistryNonPlatformExtensionsConfig;
import io.quarkus.registry.config.RegistryPlatformsConfig;
import io.quarkus.registry.config.RegistryQuarkusVersionsConfig;
import io.quarkus.registry.json.JsonBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;

public interface RegistryConfig {
    public String getId();

    public boolean isEnabled();

    public String getUpdatePolicy();

    public RegistryDescriptorConfig getDescriptor();

    public RegistryPlatformsConfig getPlatforms();

    public RegistryNonPlatformExtensionsConfig getNonPlatformExtensions();

    public RegistryMavenConfig getMaven();

    public RegistryQuarkusVersionsConfig getQuarkusVersions();

    public Map<String, Object> getExtra();

    default public Mutable mutable() {
        return new RegistryConfigImpl.Builder(this);
    }

    default public void persist(Path p) throws IOException {
        RegistriesConfigMapperHelper.serialize(this, p);
    }

    public static RegistryConfig defaultConfig() {
        return RegistryConfigImpl.getDefaultRegistry();
    }

    public static Mutable builder() {
        return new RegistryConfigImpl.Builder();
    }

    public static RegistryConfig fromFile(Path path) throws IOException {
        return RegistriesConfigMapperHelper.deserialize(path, RegistryConfigImpl.class);
    }

    public static Mutable mutableFromFile(Path path) throws IOException {
        return RegistriesConfigMapperHelper.deserialize(path, RegistryConfigImpl.Builder.class);
    }

    public static interface Mutable
    extends RegistryConfig,
    JsonBuilder<RegistryConfig> {
        public Mutable setId(String var1);

        public Mutable setEnabled(boolean var1);

        public Mutable setUpdatePolicy(String var1);

        public Mutable setDescriptor(RegistryDescriptorConfig var1);

        public Mutable setPlatforms(RegistryPlatformsConfig var1);

        public Mutable setNonPlatformExtensions(RegistryNonPlatformExtensionsConfig var1);

        public Mutable setMaven(RegistryMavenConfig var1);

        public Mutable setQuarkusVersions(RegistryQuarkusVersionsConfig var1);

        default public Mutable setAny(String name, Object value) {
            this.setExtra(name, value);
            return this;
        }

        public Mutable setExtra(Map<String, Object> var1);

        public Mutable setExtra(String var1, Object var2);

        @Override
        public RegistryConfig build();

        @Override
        default public void persist(Path p) throws IOException {
            RegistriesConfigMapperHelper.serialize(this.build(), p);
        }
    }
}

