/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.testing.registry.client;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.bootstrap.util.IoUtils;
import io.quarkus.devtools.codestarts.CodestartCatalogLoader;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.core.CodestartSpec;
import io.quarkus.devtools.testing.registry.client.TestRegistryClient;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.catalog.PlatformRelease;
import io.quarkus.registry.catalog.PlatformReleaseVersion;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.config.RegistryDescriptorConfig;
import io.quarkus.registry.config.RegistryNonPlatformExtensionsConfig;
import io.quarkus.registry.config.RegistryPlatformsConfig;
import io.quarkus.registry.config.RegistryQuarkusVersionsConfig;
import io.quarkus.registry.util.PlatformArtifacts;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;

public class TestRegistryClientBuilder {
    private Path baseDir;
    private final RegistriesConfig.Mutable config = RegistriesConfig.builder();
    private final Map<String, TestRegistryBuilder> registries = new LinkedHashMap<String, TestRegistryBuilder>();
    private List<Extension> externalExtensions = List.of();
    private List<TestCodestartBuilder> externalCodestartBuilders = List.of();
    private MavenArtifactResolver resolver;
    private boolean persistPlatformDescriptorsAsMavenArtifacts;

    public static TestRegistryClientBuilder newInstance() {
        return new TestRegistryClientBuilder();
    }

    private TestRegistryClientBuilder() {
    }

    public TestRegistryClientBuilder baseDir(Path baseDir) {
        this.baseDir = baseDir;
        return this;
    }

    public TestRegistryClientBuilder debug() {
        this.config.setDebug(true);
        return this;
    }

    public TestRegistryClientBuilder persistPlatformDescriptorsAsMavenArtifacts() {
        this.persistPlatformDescriptorsAsMavenArtifacts = true;
        return this;
    }

    public TestRegistryBuilder newRegistry(String id) {
        return this.registries.computeIfAbsent(id, i -> new TestRegistryBuilder(this, id));
    }

    public TestRegistryClientBuilder addExternalExtension(String groupId, String artifactId, String version) {
        this.addExternalExtensionInternal(groupId, artifactId, version);
        return this;
    }

    private Extension.Mutable addExternalExtensionInternal(String groupId, String artifactId, String version) {
        ArtifactCoords coords = ArtifactCoords.jar((String)groupId, (String)artifactId, (String)version);
        Extension.Mutable e = Extension.builder().setArtifact(coords).setName(artifactId);
        if (this.externalExtensions.isEmpty()) {
            this.externalExtensions = new ArrayList<Extension>();
        }
        this.externalExtensions.add((Extension)e);
        return e;
    }

    public TestCodestartBuilder addExternalExtensionWithCodestart(String groupId, String artifactId, String version) {
        Extension.Mutable e = this.addExternalExtensionInternal(groupId, artifactId, version);
        TestCodestartBuilder codestartBuilder = new TestCodestartBuilder(e, this);
        if (this.externalCodestartBuilders.isEmpty()) {
            this.externalCodestartBuilders = new ArrayList<TestCodestartBuilder>();
        }
        this.externalCodestartBuilders.add(codestartBuilder);
        return codestartBuilder;
    }

    private void installExtensionArtifacts(Collection<Extension> extensions) {
        for (Extension e : extensions) {
            Path jarPath = this.getTmpPath(e.getArtifact());
            Properties props = new Properties();
            props.setProperty("deployment-artifact", e.getArtifact().getGroupId() + ":" + e.getArtifact().getArtifactId() + "-deployment:" + e.getArtifact().getVersion());
            try (FileSystem zip = ZipUtils.newZip((Path)jarPath);){
                Path descr = zip.getPath("META-INF/quarkus-extension.properties", new String[0]);
                Files.createDirectories(descr.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(descr, new OpenOption[0]);){
                    props.store(writer, "qs cli test");
                }
                Extension.Mutable mutable = e.mutable();
                mutable.setOrigins(List.of());
                mutable.build().persist(zip.getPath("META-INF/quarkus-extension.yaml", new String[0]));
            }
            catch (IOException e1) {
                throw new UncheckedIOException(e1);
            }
            this.install(e.getArtifact(), jarPath);
            ArtifactCoords runtimePomCoords = ArtifactCoords.pom((String)e.getArtifact().getGroupId(), (String)e.getArtifact().getArtifactId(), (String)e.getArtifact().getVersion());
            jarPath = this.getTmpPath(runtimePomCoords);
            Model model = TestRegistryClientBuilder.initModel(runtimePomCoords);
            try {
                ModelUtils.persistModel((Path)jarPath, (Model)model);
            }
            catch (IOException e1) {
                throw new IllegalStateException("Failed to persist BOM at " + jarPath, e1);
            }
            this.install(runtimePomCoords, jarPath);
            ArtifactCoords deploymentJarCoords = ArtifactCoords.of((String)e.getArtifact().getGroupId(), (String)(e.getArtifact().getArtifactId() + "-deployment"), (String)e.getArtifact().getClassifier(), (String)e.getArtifact().getType(), (String)e.getArtifact().getVersion());
            jarPath = this.getTmpPath(deploymentJarCoords);
            try {
                FileSystem zip = ZipUtils.newZip((Path)jarPath);
                if (zip != null) {
                    zip.close();
                }
            }
            catch (IOException e1) {
                throw new UncheckedIOException(e1);
            }
            this.install(deploymentJarCoords, jarPath);
            ArtifactCoords deploymentPomCoords = ArtifactCoords.pom((String)deploymentJarCoords.getGroupId(), (String)deploymentJarCoords.getArtifactId(), (String)deploymentJarCoords.getVersion());
            jarPath = this.getTmpPath(deploymentPomCoords);
            model = TestRegistryClientBuilder.initModel(deploymentPomCoords);
            Dependency dep = new Dependency();
            dep.setGroupId(e.getArtifact().getGroupId());
            dep.setArtifactId(e.getArtifact().getArtifactId());
            dep.setVersion(e.getArtifact().getVersion());
            model.addDependency(dep);
            try {
                ModelUtils.persistModel((Path)jarPath, (Model)model);
            }
            catch (IOException e1) {
                throw new IllegalStateException("Failed to persist BOM at " + jarPath, e1);
            }
            this.install(deploymentPomCoords, jarPath);
        }
    }

    private void install(ArtifactCoords coords, Path path) {
        try {
            this.getResolver().install((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion(), Collections.emptyMap(), path.toFile()));
        }
        catch (BootstrapMavenException e) {
            throw new IllegalStateException("Failed to install " + path + " as " + coords, e);
        }
    }

    private Path getTmpPath(ArtifactCoords coords) {
        Path p = this.baseDir.resolve("tmp");
        for (String s : coords.getGroupId().split("\\.")) {
            p = p.resolve(s);
        }
        p = p.resolve(coords.getArtifactId()).resolve(coords.getVersion());
        try {
            Files.createDirectories(p, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create directory " + p, e);
        }
        StringBuilder b = new StringBuilder();
        b.append(coords.getArtifactId()).append('-');
        if (!coords.getClassifier().isEmpty()) {
            b.append(coords.getClassifier()).append('-');
        }
        b.append(coords.getVersion()).append('.').append(coords.getType());
        return p.resolve(b.toString());
    }

    public void build() {
        if (this.baseDir == null) {
            throw new IllegalStateException("The base directory has not been provided");
        }
        if (!Files.exists(this.baseDir, new LinkOption[0])) {
            try {
                Files.createDirectories(this.baseDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create directory " + this.baseDir, e);
            }
        } else if (!Files.isDirectory(this.baseDir, new LinkOption[0])) {
            throw new IllegalStateException(this.baseDir + " exists and is not a directory");
        }
        for (TestRegistryBuilder registry : this.registries.values()) {
            this.configureRegistry(registry);
        }
        Path configYaml = this.baseDir.resolve("config.yaml");
        try {
            this.config.persist(configYaml);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize registry client configuration " + configYaml, e);
        }
        this.externalCodestartBuilders.forEach(b -> b.persist());
        this.installExtensionArtifacts(this.externalExtensions);
    }

    private void configureRegistry(TestRegistryBuilder registry) {
        registry.configure(TestRegistryClientBuilder.getRegistryDir(this.baseDir, registry.config.getId()));
        this.config.addRegistry((RegistryConfig)registry.config);
    }

    private MavenArtifactResolver getResolver() {
        if (this.resolver == null) {
            try {
                this.resolver = new MavenArtifactResolver(new BootstrapMavenContext(BootstrapMavenContext.config().setWorkspaceDiscovery(false).setLocalRepository(this.getMavenRepoDir().toString())));
            }
            catch (BootstrapMavenException e) {
                throw new IllegalStateException("Failed to initialize Maven artifact resolver", e);
            }
        }
        return this.resolver;
    }

    private static Model initModel(ArtifactCoords coords) {
        Model pom = new Model();
        pom.setModelVersion("4.0.0");
        pom.setGroupId(coords.getGroupId());
        pom.setArtifactId(coords.getArtifactId());
        pom.setVersion(coords.getVersion());
        pom.setPackaging("pom");
        pom.setDependencyManagement(new DependencyManagement());
        Dependency d = new Dependency();
        d.setGroupId(coords.getGroupId());
        d.setArtifactId(PlatformArtifacts.ensureCatalogArtifactId((String)coords.getArtifactId()));
        d.setClassifier(coords.getVersion());
        d.setType("json");
        d.setVersion(coords.getVersion());
        pom.getDependencyManagement().addDependency(d);
        return pom;
    }

    private static void persistPlatformCatalog(PlatformCatalog catalog, Path dir) {
        Path platformsJson = dir.resolve("platforms.json");
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            catalog.persist(platformsJson);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to persist platform catalog " + platformsJson, e);
        }
    }

    public static Path getRegistryMemberCatalogPath(Path registryDir, ArtifactCoords bom) {
        return TestRegistryClientBuilder.getMemberCatalogPath(registryDir.resolve("members"), bom);
    }

    private static Path getMemberCatalogPath(Path memberDir, ArtifactCoords bom) {
        return memberDir.resolve(bom.getGroupId() + "." + bom.getArtifactId() + "." + bom.getVersion() + ".json");
    }

    static Path getRegistryNonPlatformCatalogPath(Path registryDir, String quarkusVersion) {
        return TestRegistryClientBuilder.getNonPlatformCatalogPath(registryDir.resolve("non-platform"), quarkusVersion);
    }

    private static Path getNonPlatformCatalogPath(Path nonPlatformDir, String quarkusVersion) {
        return nonPlatformDir.resolve(quarkusVersion + ".json");
    }

    static Path getRegistryPlatformsCatalogPath(Path registryDir, String quarkusVersion) {
        return quarkusVersion == null ? TestRegistryClientBuilder.getRegistryPlatformsDir(registryDir).resolve("platforms.json") : TestRegistryClientBuilder.getRegistryPlatformsDir(registryDir).resolve(quarkusVersion).resolve("platforms.json");
    }

    private static Path getRegistryNonPlatformDir(Path registryDir) {
        return registryDir.resolve("non-platform");
    }

    private static Path getRegistryPlatformsDir(Path registryDir) {
        return registryDir.resolve("platforms");
    }

    static Path getRegistryDescriptorPath(Path registryDir) {
        return registryDir.resolve("config.json");
    }

    public static Path getRegistryDir(Path baseDir, String registryId) {
        return baseDir.resolve(registryId);
    }

    private Path getMavenRepoDir() {
        return TestRegistryClientBuilder.getMavenRepoDir(this.baseDir);
    }

    public static Path getMavenRepoDir(Path baseDir) {
        return baseDir.resolve("maven-repo");
    }

    private static String registryIdToGroupId(String id) {
        String[] groupIdParts = id.split("\\.");
        if (groupIdParts.length == 1) {
            return groupIdParts[0];
        }
        StringJoiner joiner = new StringJoiner(".");
        for (int i = groupIdParts.length - 1; i >= 0; --i) {
            joiner.add(groupIdParts[i]);
        }
        return joiner.toString();
    }

    public static class TestRegistryBuilder {
        private final TestRegistryClientBuilder parent;
        private final String registryGroupId;
        private final RegistryConfig.Mutable config = RegistryConfig.builder();
        private final RegistryDescriptorConfig.Mutable descrConfig = RegistryDescriptorConfig.builder();
        private RegistryQuarkusVersionsConfig.Mutable quarkusVersions;
        private boolean external;
        private PlatformCatalog.Mutable platformCatalog;
        private PlatformCatalog.Mutable archivedPlatformCatalog;
        private List<TestPlatformCatalogMemberBuilder> memberCatalogs;
        private List<TestNonPlatformCatalogBuilder> nonPlatformCatalogs;
        private boolean enableMavenResolver;

        private TestRegistryBuilder(TestRegistryClientBuilder parent, String id) {
            this.parent = parent;
            this.config.setId(Objects.requireNonNull(id));
            this.registryGroupId = TestRegistryClientBuilder.registryIdToGroupId(id);
            this.descrConfig.setArtifact(ArtifactCoords.of((String)this.registryGroupId, (String)"quarkus-registry-descriptor", null, (String)"json", (String)"1.0-SNAPSHOT"));
        }

        public TestRegistryBuilder external() {
            this.external = true;
            return this;
        }

        public TestRegistryBuilder disabled() {
            this.config.setEnabled(false);
            return this;
        }

        public TestRegistryBuilder platformCatalog(PlatformCatalog newCatalog) {
            this.platformCatalog = newCatalog instanceof PlatformCatalog.Mutable ? (PlatformCatalog.Mutable)newCatalog : newCatalog.mutable();
            return this;
        }

        public TestPlatformCatalogPlatformBuilder newPlatform(String platformKey) {
            Platform.Mutable platform;
            if (this.platformCatalog == null) {
                this.platformCatalog = PlatformCatalog.builder();
            }
            if ((platform = (Platform.Mutable)this.platformCatalog.getPlatform(platformKey)) == null) {
                platform = Platform.builder().setPlatformKey(platformKey);
                this.platformCatalog.addPlatform((Platform)platform);
            }
            return new TestPlatformCatalogPlatformBuilder(this, platform);
        }

        public TestNonPlatformCatalogBuilder newNonPlatformCatalog(String quarkusVersion) {
            TestNonPlatformCatalogBuilder builder = new TestNonPlatformCatalogBuilder(this, quarkusVersion);
            if (this.nonPlatformCatalogs == null) {
                this.nonPlatformCatalogs = new ArrayList<TestNonPlatformCatalogBuilder>();
            }
            this.nonPlatformCatalogs.add(builder);
            return builder;
        }

        public TestRegistryBuilder recognizedQuarkusVersions(String expr) {
            return this.recognizedQuarkusVersions(expr, true);
        }

        public TestRegistryBuilder recognizedQuarkusVersions(String expr, boolean exclusiveProvider) {
            if (this.quarkusVersions == null) {
                this.quarkusVersions = RegistryQuarkusVersionsConfig.builder();
            }
            this.quarkusVersions.setRecognizedVersionsExpression(expr);
            this.quarkusVersions.setExclusiveProvider(exclusiveProvider);
            return this;
        }

        public TestRegistryClientBuilder clientBuilder() {
            return this.parent;
        }

        private void addMemberCatalog(TestPlatformCatalogMemberBuilder member) {
            if (this.memberCatalogs == null) {
                this.memberCatalogs = new ArrayList<TestPlatformCatalogMemberBuilder>();
            }
            this.memberCatalogs.add(member);
        }

        private void configure(Path registryDir) {
            if (Files.exists(registryDir, new LinkOption[0])) {
                if (!Files.isDirectory(registryDir, new LinkOption[0])) {
                    throw new IllegalStateException(registryDir + " exists and is not a directory");
                }
                IoUtils.recursiveDelete((Path)registryDir);
            }
            try {
                Files.createDirectories(registryDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to create directory " + registryDir, e);
            }
            if (!this.external) {
                this.config.setExtra("client-factory-url", (Object)TestRegistryClient.class.getProtectionDomain().getCodeSource().getLocation().toExternalForm());
                if (this.enableMavenResolver) {
                    this.config.setExtra("enable-maven-resolver", (Object)true);
                }
            }
            RegistryConfig.Mutable registryConfig = RegistryConfig.builder();
            registryConfig.setId(this.config.getId());
            registryConfig.setDescriptor((RegistryDescriptorConfig)this.descrConfig);
            if (this.quarkusVersions != null) {
                registryConfig.setQuarkusVersions((RegistryQuarkusVersionsConfig)this.quarkusVersions);
            }
            RegistryPlatformsConfig.Mutable platformConfig = RegistryPlatformsConfig.builder().setArtifact(ArtifactCoords.of((String)this.registryGroupId, (String)"quarkus-platforms", null, (String)"json", (String)"1.0-SNAPSHOT"));
            if (this.platformCatalog == null && this.archivedPlatformCatalog == null) {
                platformConfig.setDisabled(true);
            } else {
                PlatformCatalog.Mutable c;
                Path platformsDir = TestRegistryClientBuilder.getRegistryPlatformsDir(registryDir);
                HashMap<String, PlatformCatalog.Mutable> platformsByQuarkusVersion = new HashMap<String, PlatformCatalog.Mutable>();
                PlatformCatalog.Mutable allPlatforms = PlatformCatalog.builder();
                if (this.platformCatalog != null) {
                    TestRegistryClientBuilder.persistPlatformCatalog(this.platformCatalog.build(), platformsDir);
                    for (Platform p : this.platformCatalog.getPlatforms()) {
                        for (PlatformStream s : p.getStreams()) {
                            for (PlatformRelease r : s.getReleases()) {
                                if (r.getQuarkusCoreVersion() == null) {
                                    throw new IllegalStateException("Quarkus version has not be configured for platform release " + p.getPlatformKey() + ":" + s.getId() + ":" + r.getVersion());
                                }
                                c = platformsByQuarkusVersion.computeIfAbsent(r.getQuarkusCoreVersion(), v -> PlatformCatalog.builder());
                                this.addPlatformRelease(p, s, r, c);
                                this.addPlatformRelease(p, s, r, allPlatforms);
                            }
                        }
                    }
                }
                if (this.archivedPlatformCatalog != null) {
                    for (Platform p : this.archivedPlatformCatalog.getPlatforms()) {
                        for (PlatformStream s : p.getStreams()) {
                            for (PlatformRelease r : s.getReleases()) {
                                if (r.getQuarkusCoreVersion() == null) {
                                    throw new IllegalStateException("Quarkus version has not be configured for platform release " + p.getPlatformKey() + ":" + s.getId() + ":" + r.getVersion());
                                }
                                c = platformsByQuarkusVersion.computeIfAbsent(r.getQuarkusCoreVersion(), v -> PlatformCatalog.builder());
                                this.addPlatformRelease(p, s, r, c);
                                this.addPlatformRelease(p, s, r, allPlatforms);
                            }
                        }
                    }
                }
                for (Map.Entry entry : platformsByQuarkusVersion.entrySet()) {
                    TestRegistryClientBuilder.persistPlatformCatalog(((PlatformCatalog.Mutable)entry.getValue()).build(), platformsDir.resolve((String)entry.getKey()));
                }
                TestRegistryClientBuilder.persistPlatformCatalog(allPlatforms.build(), platformsDir.resolve("all"));
                if (this.memberCatalogs != null && !this.memberCatalogs.isEmpty()) {
                    platformConfig.setExtensionCatalogsIncluded(Boolean.valueOf(true));
                }
            }
            registryConfig.setPlatforms((RegistryPlatformsConfig)platformConfig);
            RegistryNonPlatformExtensionsConfig.Mutable nonPlatformConfig = RegistryNonPlatformExtensionsConfig.builder();
            nonPlatformConfig.setArtifact(this.getRegistryNonPlatformCatalogArtifact());
            if (this.nonPlatformCatalogs == null || this.nonPlatformCatalogs.isEmpty()) {
                nonPlatformConfig.setDisabled(true);
            } else {
                Path nonPlatformDir = TestRegistryClientBuilder.getRegistryNonPlatformDir(registryDir);
                for (TestNonPlatformCatalogBuilder nonPlatformCatalog : this.nonPlatformCatalogs) {
                    nonPlatformCatalog.persist(nonPlatformDir);
                }
            }
            registryConfig.setNonPlatformExtensions((RegistryNonPlatformExtensionsConfig)nonPlatformConfig);
            if (this.memberCatalogs != null) {
                Path membersDir = registryDir.resolve("members");
                try {
                    Files.createDirectories(membersDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to create directory " + membersDir, e);
                }
                for (TestPlatformCatalogMemberBuilder member : this.memberCatalogs) {
                    member.persist(membersDir);
                }
            }
            Path descriptorJson = TestRegistryClientBuilder.getRegistryDescriptorPath(registryDir);
            try {
                registryConfig.persist(descriptorJson);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to persist registry descriptor " + descriptorJson, e);
            }
        }

        protected void addPlatformRelease(Platform platform, PlatformStream stream, PlatformRelease release, PlatformCatalog.Mutable catalog) {
            PlatformStream.Mutable ms;
            Platform.Mutable mp = (Platform.Mutable)catalog.getPlatform(platform.getPlatformKey());
            if (mp == null) {
                mp = Platform.builder().setPlatformKey(platform.getPlatformKey());
                catalog.addPlatform((Platform)mp);
            }
            if ((ms = (PlatformStream.Mutable)mp.getStream(stream.getId())) == null) {
                ms = PlatformStream.builder().setId(stream.getId());
                mp.addStream((PlatformStream)ms);
            }
            ms.addRelease(release);
        }

        private ArtifactCoords getRegistryNonPlatformCatalogArtifact() {
            return ArtifactCoords.of((String)this.registryGroupId, (String)"quarkus-non-platform-extensions", null, (String)"json", (String)"1.0-SNAPSHOT");
        }
    }

    public static class TestCodestartBuilder {
        final Extension.Mutable ext;
        final TestRegistryClientBuilder clientBuilder;

        private TestCodestartBuilder(Extension.Mutable ext, TestRegistryClientBuilder clientBuilder) {
            this.ext = ext;
            this.clientBuilder = clientBuilder;
        }

        public TestRegistryClientBuilder clientBuilder() {
            return this.clientBuilder;
        }

        protected void persist() {
            Map metadata = (Map)this.ext.getMetadata().computeIfAbsent("codestart", k -> new HashMap());
            if (!metadata.containsKey("name")) {
                metadata.put("name", this.ext.getArtifact().getArtifactId() + "-codestart");
            }
            if (!metadata.containsKey("languages")) {
                metadata.put("languages", List.of("java"));
            }
            ArtifactCoords extCoords = this.ext.getArtifact();
            ArtifactCoords codestartCoords = ArtifactCoords.jar((String)extCoords.getGroupId(), (String)extCoords.getArtifactId(), (String)"codestart", (String)extCoords.getVersion());
            if (!metadata.containsKey("artifact")) {
                metadata.put("artifact", codestartCoords.toString());
            }
            Path jarPath = this.clientBuilder.getTmpPath(codestartCoords);
            try (FileSystem zip = ZipUtils.newZip((Path)jarPath);){
                Path baseDir = zip.getPath("codestarts/quarkus/" + codestartCoords.getArtifactId() + "-codestart", new String[0]);
                CodestartSpec spec = new CodestartSpec(codestartCoords.getArtifactId() + "-codestart", codestartCoords.getArtifactId() + "-ref", CodestartType.CODE, false, false, Set.of("extension-codestart"), Map.of("title", codestartCoords.getArtifactId() + " code", "description", codestartCoords.getArtifactId() + " example"), Map.of(), Map.of());
                CodestartCatalogLoader.persist((CodestartSpec)spec, (Path)baseDir.resolve("codestart.yml"));
                StringBuilder sb = new StringBuilder(codestartCoords.getArtifactId().length());
                boolean nextUpperCase = true;
                for (int i = 0; i < codestartCoords.getArtifactId().length(); ++i) {
                    char c = codestartCoords.getArtifactId().charAt(i);
                    if (c == '-') {
                        nextUpperCase = true;
                        continue;
                    }
                    if (nextUpperCase) {
                        c = Character.toUpperCase(c);
                        nextUpperCase = false;
                    }
                    sb.append(c);
                }
                String className = sb.toString();
                Path javaClassPath = baseDir.resolve("java/src/main/java/org/acme").resolve(sb.append(".java").toString());
                Files.createDirectories(javaClassPath.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(javaClassPath, new OpenOption[0]);){
                    writer.write("package org.acme;");
                    writer.newLine();
                    writer.write("public class ");
                    writer.write(className);
                    writer.write(" {}");
                }
            }
            catch (IOException e1) {
                throw new UncheckedIOException(e1);
            }
            this.clientBuilder().install(codestartCoords, jarPath);
        }
    }

    public static class TestNonPlatformCodestartBuilder
    extends TestCodestartBuilder {
        private final TestNonPlatformCatalogBuilder catalogBuilder;

        private TestNonPlatformCodestartBuilder(Extension.Mutable ext, TestNonPlatformCatalogBuilder catalogBuilder) {
            super(ext, catalogBuilder.registry.clientBuilder());
            this.catalogBuilder = catalogBuilder;
        }

        public TestNonPlatformCatalogBuilder catalog() {
            return this.catalogBuilder;
        }
    }

    public static class TestNonPlatformCatalogBuilder {
        private final TestRegistryBuilder registry;
        private final ExtensionCatalog.Mutable extensions = ExtensionCatalog.builder();
        private List<TestCodestartBuilder> codestarts = List.of();

        private TestNonPlatformCatalogBuilder(TestRegistryBuilder registry, String quarkusVersion) {
            this.registry = registry;
            ArtifactCoords baseCoords = registry.getRegistryNonPlatformCatalogArtifact();
            this.extensions.setId(ArtifactCoords.of((String)baseCoords.getGroupId(), (String)baseCoords.getArtifactId(), (String)quarkusVersion, (String)baseCoords.getType(), (String)baseCoords.getVersion()).toString());
            this.extensions.setPlatform(false);
            this.extensions.setQuarkusCoreVersion(quarkusVersion);
            this.extensions.setBom(ArtifactCoords.pom((String)"io.quarkus", (String)"quarkus-bom", (String)quarkusVersion));
        }

        public TestNonPlatformCatalogBuilder addExtension(String groupId, String artifactId, String version) {
            this.addExtensionToCatalog(groupId, artifactId, version);
            return this;
        }

        private Extension.Mutable addExtensionToCatalog(String groupId, String artifactId, String version) {
            Extension.Mutable e = Extension.builder().setArtifact(ArtifactCoords.jar((String)groupId, (String)artifactId, (String)version)).setName(artifactId).setOrigins(Collections.singletonList(this.extensions));
            this.extensions.addExtension((Extension)e);
            return e;
        }

        public TestNonPlatformCodestartBuilder addExtensionWithCodestart(String groupId, String artifactId, String version) {
            TestNonPlatformCodestartBuilder codestartBuilder = new TestNonPlatformCodestartBuilder(this.addExtensionToCatalog(groupId, artifactId, version), this);
            if (this.codestarts.isEmpty()) {
                this.codestarts = new ArrayList<TestCodestartBuilder>();
            }
            this.codestarts.add(codestartBuilder);
            return codestartBuilder;
        }

        public TestRegistryBuilder registry() {
            return this.registry;
        }

        private void persist(Path nonPlatformDir) {
            this.codestarts.forEach(c -> c.persist());
            Path json = TestRegistryClientBuilder.getNonPlatformCatalogPath(nonPlatformDir, this.extensions.getQuarkusCoreVersion());
            try {
                this.extensions.persist(json);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to persist extension catalog " + json, e);
            }
            this.registry().clientBuilder().installExtensionArtifacts(this.extensions.getExtensions());
        }
    }

    public static class TestPlatformCatalogMemberBuilder {
        private final TestPlatformCatalogReleaseBuilder release;
        private final ExtensionCatalog.Mutable extensions = ExtensionCatalog.builder();
        private final Model pom;

        private TestPlatformCatalogMemberBuilder(TestPlatformCatalogReleaseBuilder release, ArtifactCoords bom) {
            this.release = release;
            release.stream.platform.registry.addMemberCatalog(this);
            this.extensions.setBom(bom);
            this.extensions.setId(PlatformArtifacts.ensureCatalogArtifact((ArtifactCoords)bom).toString());
            this.extensions.setPlatform(true);
            this.pom = TestRegistryClientBuilder.initModel(bom);
        }

        private Map<String, Object> getProjectProperties() {
            Map metadata = this.extensions.getMetadata();
            metadata = (Map)metadata.computeIfAbsent("project", s -> new HashMap());
            metadata = (Map)metadata.computeIfAbsent("properties", s -> new HashMap());
            return metadata;
        }

        public TestPlatformCatalogMemberBuilder alignPluginsOnQuarkusVersion() {
            Map<String, Object> metadata = this.getProjectProperties();
            metadata.put("maven-plugin-groupId", "io.quarkus");
            metadata.put("maven-plugin-artifactId", "quarkus-maven-plugin");
            metadata.put("maven-plugin-version", this.release.release.getQuarkusCoreVersion());
            return this;
        }

        public TestPlatformCatalogMemberBuilder addProjectMavenRepo(String id, String url) {
            Map metadata = this.extensions.getMetadata();
            metadata = (Map)metadata.computeIfAbsent("maven", s -> new HashMap());
            List repos = (List)metadata.computeIfAbsent("repositories", s -> new ArrayList());
            HashMap<String, String> repo = new HashMap<String, String>();
            repo.put("id", id);
            repo.put("url", url);
            repo.put("releases-enabled", "true");
            repo.put("snapshots-enabled", "true");
            repos.add(repo);
            return this;
        }

        public TestPlatformCatalogMemberBuilder addDefaultCodestartExtensions() {
            String quarkusVersion = this.release.release.getQuarkusCoreVersion();
            this.addExtension("io.quarkus", "quarkus-arc", quarkusVersion);
            this.addExtension("io.quarkus", "quarkus-resteasy", quarkusVersion);
            Dependency dep = new Dependency();
            dep.setGroupId("io.quarkus");
            dep.setArtifactId("quarkus-junit5");
            dep.setVersion(quarkusVersion);
            this.pom.getDependencyManagement().addDependency(dep);
            dep = new Dependency();
            dep.setGroupId("io.rest-assured");
            dep.setArtifactId("rest-assured");
            dep.setVersion("4.4.0");
            this.pom.getDependencyManagement().addDependency(dep);
            return this;
        }

        public TestPlatformCatalogMemberBuilder addExtension(String artifactId) {
            return this.addExtension(this.extensions.getBom().getGroupId(), artifactId, this.extensions.getBom().getVersion());
        }

        public TestPlatformCatalogMemberBuilder addExtension(String groupId, String artifactId, String version) {
            ArtifactCoords coords = ArtifactCoords.jar((String)groupId, (String)artifactId, (String)version);
            Extension.Mutable e = Extension.builder().setArtifact(coords).setName(artifactId).setOrigins(Collections.singletonList(this.extensions));
            this.extensions.addExtension((Extension)e);
            Dependency d = new Dependency();
            d.setGroupId(coords.getGroupId());
            d.setArtifactId(coords.getArtifactId());
            if (!coords.getClassifier().isBlank()) {
                d.setClassifier(coords.getClassifier());
            }
            if (!coords.getType().equals("jar")) {
                d.setType(coords.getType());
            }
            d.setVersion(coords.getVersion());
            this.pom.getDependencyManagement().addDependency(d);
            return this;
        }

        public TestPlatformCatalogReleaseBuilder release() {
            return this.release;
        }

        public TestRegistryBuilder registry() {
            return this.release.stream.platform.registry;
        }

        private void install(ArtifactCoords coords, Path path) {
            try {
                this.registry().clientBuilder().getResolver().install((Artifact)new DefaultArtifact(coords.getGroupId(), coords.getArtifactId(), coords.getClassifier(), coords.getType(), coords.getVersion(), Map.of(), path.toFile()));
            }
            catch (BootstrapMavenException e) {
                throw new IllegalStateException("Failed to install " + path + " as " + coords, e);
            }
        }

        private void persist(Path memberDir) {
            this.release.setReleaseInfo(this.extensions);
            ArtifactCoords bom = this.extensions.getBom();
            Path json = TestRegistryClientBuilder.getMemberCatalogPath(memberDir, bom);
            try {
                this.extensions.persist(json);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to persist extension catalog " + json, e);
            }
            if (this.registry().clientBuilder().persistPlatformDescriptorsAsMavenArtifacts) {
                this.install(PlatformArtifacts.ensureCatalogArtifact((ArtifactCoords)bom), json);
            }
            Path artifactPath = this.registry().clientBuilder().getTmpPath(bom);
            try {
                ModelUtils.persistModel((Path)artifactPath, (Model)this.pom);
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to persist BOM at " + artifactPath, e);
            }
            this.install(bom, artifactPath);
            this.registry().clientBuilder().installExtensionArtifacts(this.extensions.getExtensions());
        }
    }

    public static class TestPlatformCatalogReleaseBuilder {
        private final TestPlatformCatalogStreamBuilder stream;
        private final PlatformRelease.Mutable release;

        private TestPlatformCatalogReleaseBuilder(TestPlatformCatalogStreamBuilder stream, PlatformRelease.Mutable release) {
            this.stream = stream;
            this.release = release;
        }

        public TestPlatformCatalogReleaseBuilder quarkusVersion(String quarkusVersion) {
            this.release.setQuarkusCoreVersion(quarkusVersion);
            return this;
        }

        public TestPlatformCatalogReleaseBuilder upstreamQuarkusVersion(String quarkusVersion) {
            this.release.setUpstreamQuarkusCoreVersion(quarkusVersion);
            return this;
        }

        public TestPlatformCatalogReleaseBuilder addMemberBom(ArtifactCoords bom) {
            this.addMemberBomInternal(bom);
            this.registry().enableMavenResolver = true;
            return this;
        }

        public TestPlatformCatalogMemberBuilder newMember(String artifactId) {
            ArtifactCoords bom = ArtifactCoords.pom((String)this.stream.platform.platform.getPlatformKey(), (String)artifactId, (String)this.release.getVersion().toString());
            this.addMemberBomInternal(bom);
            return new TestPlatformCatalogMemberBuilder(this, bom);
        }

        public TestPlatformCatalogMemberBuilder addCoreMember() {
            if (this.release.getQuarkusCoreVersion() == null) {
                throw new RuntimeException("Quarkus core version hasn't been set");
            }
            TestPlatformCatalogMemberBuilder quarkusBom = this.newMember("quarkus-bom");
            quarkusBom.addExtension("io.quarkus", "quarkus-core", this.release.getQuarkusCoreVersion());
            Map<String, Object> metadata = quarkusBom.getProjectProperties();
            metadata.put("maven-plugin-groupId", quarkusBom.extensions.getBom().getGroupId());
            metadata.put("maven-plugin-artifactId", "quarkus-maven-plugin");
            metadata.put("maven-plugin-version", quarkusBom.extensions.getBom().getVersion());
            metadata.put("compiler-plugin-version", "3.8.1");
            metadata.put("surefire-plugin-version", "3.0.0");
            return quarkusBom;
        }

        public TestPlatformCatalogStreamBuilder stream() {
            return this.stream;
        }

        public TestRegistryBuilder registry() {
            return this.stream.platform.registry;
        }

        private void addMemberBomInternal(ArtifactCoords bom) {
            this.release.getMemberBoms().add(bom);
        }

        private void setReleaseInfo(ExtensionCatalog.Mutable catalog) {
            catalog.setQuarkusCoreVersion(this.release.getQuarkusCoreVersion());
            if (this.release.getUpstreamQuarkusCoreVersion() != null) {
                catalog.setUpstreamQuarkusCoreVersion(this.release.getUpstreamQuarkusCoreVersion());
            }
            Map metadata = catalog.getMetadata();
            metadata = (Map)metadata.computeIfAbsent("platform-release", k -> new HashMap());
            metadata.put("platform-key", this.stream.platform.platform.getPlatformKey());
            metadata.put("stream", this.stream.stream.getId());
            metadata.put("version", this.release.getVersion());
            ArrayList<ArtifactCoords> members = new ArrayList<ArtifactCoords>(this.release.getMemberBoms().size());
            for (ArtifactCoords coords : this.release.getMemberBoms()) {
                members.add(PlatformArtifacts.ensureCatalogArtifact((ArtifactCoords)coords));
            }
            metadata.put("members", members);
        }
    }

    public static class TestPlatformCatalogStreamBuilder {
        private final TestPlatformCatalogPlatformBuilder platform;
        private final PlatformStream.Mutable stream;

        private TestPlatformCatalogStreamBuilder(TestPlatformCatalogPlatformBuilder platform, PlatformStream.Mutable stream) {
            this.platform = platform;
            this.stream = stream;
        }

        public TestPlatformCatalogReleaseBuilder newRelease(String version) {
            PlatformRelease.Mutable release = PlatformRelease.builder().setVersion(PlatformReleaseVersion.fromString((String)version));
            this.stream.addRelease((PlatformRelease)release);
            return new TestPlatformCatalogReleaseBuilder(this, release);
        }

        public TestPlatformCatalogReleaseBuilder newArchivedRelease(String version) {
            PlatformStream.Mutable archivedStream;
            Platform.Mutable archivedPlatform;
            PlatformRelease.Mutable release = PlatformRelease.builder().setVersion(PlatformReleaseVersion.fromString((String)version));
            if (this.platform.registry.archivedPlatformCatalog == null) {
                this.platform.registry.archivedPlatformCatalog = PlatformCatalog.builder();
            }
            if ((archivedPlatform = (Platform.Mutable)this.platform.registry.archivedPlatformCatalog.getPlatform(this.platform.platform.getPlatformKey())) == null) {
                archivedPlatform = Platform.builder().setPlatformKey(this.platform.platform.getPlatformKey());
                this.platform.registry.archivedPlatformCatalog.addPlatform((Platform)archivedPlatform);
            }
            if ((archivedStream = (PlatformStream.Mutable)archivedPlatform.getStream(this.stream.getId())) == null) {
                archivedStream = PlatformStream.builder().setId(this.stream.getId());
                archivedPlatform.addStream((PlatformStream)archivedStream);
            }
            archivedStream.addRelease((PlatformRelease)release);
            return new TestPlatformCatalogReleaseBuilder(this, release);
        }

        public TestPlatformCatalogPlatformBuilder platform() {
            return this.platform;
        }
    }

    public static class TestPlatformCatalogPlatformBuilder {
        private final TestRegistryBuilder registry;
        private final Platform.Mutable platform;

        private TestPlatformCatalogPlatformBuilder(TestRegistryBuilder registry, Platform.Mutable platform) {
            this.registry = registry;
            this.platform = platform;
        }

        public TestPlatformCatalogStreamBuilder newStream(String id) {
            PlatformStream.Mutable stream = PlatformStream.builder().setId(id);
            this.platform.addStream((PlatformStream)stream);
            return new TestPlatformCatalogStreamBuilder(this, stream);
        }

        public TestPlatformCatalogStreamBuilder newArchivedStream(String id) {
            PlatformStream.Mutable archivedStream;
            Platform.Mutable archivedPlatform;
            if (this.registry.archivedPlatformCatalog == null) {
                this.registry.archivedPlatformCatalog = PlatformCatalog.builder();
            }
            if ((archivedPlatform = (Platform.Mutable)this.registry.archivedPlatformCatalog.getPlatform(this.platform.getPlatformKey())) == null) {
                archivedPlatform = Platform.builder().setPlatformKey(this.platform.getPlatformKey());
                this.registry.archivedPlatformCatalog.addPlatform((Platform)archivedPlatform);
            }
            if ((archivedStream = (PlatformStream.Mutable)archivedPlatform.getStream(id)) == null) {
                archivedStream = PlatformStream.builder().setId(id);
                archivedPlatform.addStream((PlatformStream)archivedStream);
            }
            return new TestPlatformCatalogStreamBuilder(this, archivedStream);
        }

        public TestRegistryBuilder registry() {
            return this.registry;
        }
    }
}

