/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.spi.buildtime;

import io.quarkus.runtime.RuntimeValue;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

public class BuildTimeAction {
    private final String methodName;
    private final Function<Map<String, String>, ?> action;
    private final BiFunction<Object, Map<String, String>, ?> assistantAction;
    private final RuntimeValue runtimeValue;

    protected <T> BuildTimeAction(String methodName, Function<Map<String, String>, T> action) {
        this.methodName = methodName;
        this.action = action;
        this.assistantAction = null;
        this.runtimeValue = null;
    }

    protected <T> BuildTimeAction(String methodName, BiFunction<Object, Map<String, String>, T> assistantAction) {
        this.methodName = methodName;
        this.action = null;
        this.assistantAction = assistantAction;
        this.runtimeValue = null;
    }

    protected <T> BuildTimeAction(String methodName, RuntimeValue runtimeValue) {
        this.methodName = methodName;
        this.action = null;
        this.assistantAction = null;
        this.runtimeValue = runtimeValue;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Function<Map<String, String>, ?> getAction() {
        return this.action;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public BiFunction<Object, Map<String, String>, ?> getAssistantAction() {
        return this.assistantAction;
    }

    public boolean hasAssistantAction() {
        return this.assistantAction != null;
    }

    public RuntimeValue getRuntimeValue() {
        return this.runtimeValue;
    }

    public boolean hasRuntimeValue() {
        return this.runtimeValue != null;
    }
}

