/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.extension;

import io.quarkus.annotation.processor.ExtensionProcessor;
import io.quarkus.annotation.processor.util.Config;
import io.quarkus.annotation.processor.util.Utils;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;

public class ExtensionBuildProcessor
implements ExtensionProcessor {
    private Utils utils;
    private final Set<String> processorClassNames = new TreeSet<String>();
    private final Set<String> recorderClassNames = new TreeSet<String>();
    private final Set<String> configRootClassNames = new TreeSet<String>();
    private final Map<String, Boolean> annotationUsageTracker = new ConcurrentHashMap<String, Boolean>();

    @Override
    public void init(Config config, Utils utils) {
        this.utils = utils;
    }

    @Override
    public void process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            switch (typeElement.getQualifiedName().toString()) {
                case "io.quarkus.deployment.annotations.BuildStep": {
                    this.trackAnnotationUsed("io.quarkus.deployment.annotations.BuildStep");
                    this.processBuildStep(roundEnv, typeElement);
                    break;
                }
                case "io.quarkus.runtime.annotations.Recorder": {
                    this.trackAnnotationUsed("io.quarkus.runtime.annotations.Recorder");
                    this.processRecorder(roundEnv, typeElement);
                    break;
                }
                case "io.quarkus.runtime.annotations.ConfigRoot": {
                    this.trackAnnotationUsed("io.quarkus.runtime.annotations.ConfigRoot");
                    this.processConfigRoot(roundEnv, typeElement);
                    break;
                }
                case "io.quarkus.runtime.annotations.ConfigGroup": {
                    this.trackAnnotationUsed("io.quarkus.runtime.annotations.ConfigGroup");
                    this.processConfigGroup(roundEnv, typeElement);
                }
            }
        }
    }

    @Override
    public void finalizeProcessing() {
        this.validateAnnotationUsage();
        TreeSet<String> allProcessorClassNames = new TreeSet<String>(this.processorClassNames);
        allProcessorClassNames.addAll(this.utils.filer().readSet("META-INF/quarkus-build-steps.list"));
        this.utils.filer().writeSet("META-INF/quarkus-build-steps.list", allProcessorClassNames);
        this.utils.filer().writeSet("META-INF/quarkus-config-roots.list", this.configRootClassNames);
    }

    private void processBuildStep(RoundEnvironment roundEnv, TypeElement annotation) {
        for (ExecutableElement buildStep : ElementFilter.methodsIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            TypeElement clazz = this.utils.element().getClassOf(buildStep);
            if (clazz == null) continue;
            PackageElement pkg = this.utils.element().getPackageOf(clazz);
            if (pkg == null) {
                this.utils.processingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, "Element " + String.valueOf(clazz) + " has no enclosing package");
                continue;
            }
            String binaryName = this.utils.element().getBinaryName(clazz);
            if (!this.processorClassNames.add(binaryName)) continue;
            this.validateRecordBuildSteps(clazz);
            this.utils.accessorGenerator().generateAccessor(clazz);
        }
    }

    private void validateRecordBuildSteps(TypeElement clazz) {
        for (Element element : clazz.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement ex = (ExecutableElement)element;
            if (!this.utils.element().isAnnotationPresent(ex, "io.quarkus.deployment.annotations.BuildStep") || !this.utils.element().isAnnotationPresent(ex, "io.quarkus.deployment.annotations.Record")) continue;
            boolean hasRecorder = false;
            boolean allTypesResolvable = true;
            for (VariableElement variableElement : ex.getParameters()) {
                String parameterClassName = variableElement.asType().toString();
                TypeElement parameterTypeElement = this.utils.processingEnv().getElementUtils().getTypeElement(parameterClassName);
                if (parameterTypeElement == null) {
                    allTypesResolvable = false;
                    continue;
                }
                if (!this.utils.element().isAnnotationPresent(parameterTypeElement, "io.quarkus.runtime.annotations.Recorder")) continue;
                if (parameterTypeElement.getModifiers().contains((Object)Modifier.FINAL)) {
                    this.utils.processingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, "Class '" + String.valueOf(parameterTypeElement.getQualifiedName()) + "' is annotated with @Recorder and therefore cannot be made as a final class.");
                } else if (this.utils.element().getPackageName(clazz).equals(this.utils.element().getPackageName(parameterTypeElement))) {
                    this.utils.processingEnv().getMessager().printMessage(Diagnostic.Kind.WARNING, "Build step class '" + String.valueOf(clazz.getQualifiedName()) + "' and recorder '" + String.valueOf(parameterTypeElement) + "' share the same package. This is highly discouraged as it can lead to unexpected results.");
                }
                hasRecorder = true;
                break;
            }
            if (hasRecorder || !allTypesResolvable) continue;
            this.utils.processingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, "Build Step '" + String.valueOf(clazz.getQualifiedName()) + "#" + String.valueOf(ex.getSimpleName()) + "' which is annotated with '@Record' does not contain a method parameter whose type is annotated with '@Recorder'.");
        }
    }

    private void processRecorder(RoundEnvironment roundEnv, TypeElement annotation) {
        for (TypeElement recorder : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            if (!this.recorderClassNames.add(recorder.getQualifiedName().toString())) continue;
            this.utils.accessorGenerator().generateAccessor(recorder);
        }
    }

    private void processConfigRoot(RoundEnvironment roundEnv, TypeElement annotation) {
        for (TypeElement configRoot : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            this.configRootClassNames.add(this.utils.element().getBinaryName(configRoot));
        }
    }

    private void processConfigGroup(RoundEnvironment roundEnv, TypeElement annotation) {
        for (TypeElement typeElement : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotation))) {
        }
    }

    private void validateAnnotationUsage() {
        if (this.isAnnotationUsed("io.quarkus.deployment.annotations.BuildStep") && this.isAnnotationUsed("io.quarkus.runtime.annotations.Recorder")) {
            this.utils.processingEnv().getMessager().printMessage(Diagnostic.Kind.ERROR, "Detected use of @Recorder annotation in 'deployment' module. Classes annotated with @Recorder must be part of the extension's 'runtime' module");
        }
    }

    private boolean isAnnotationUsed(String annotation) {
        return this.annotationUsageTracker.getOrDefault(annotation, false);
    }

    private void trackAnnotationUsed(String annotation) {
        this.annotationUsageTracker.put(annotation, true);
    }
}

