/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway;

import io.quarkus.agroal.spi.JdbcInitialSQLGeneratorBuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.flyway.FlywayProcessor;
import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayContainersSupplier;
import io.quarkus.flyway.runtime.devconsole.FlywayDevConsoleRecorder;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;

public class FlywayDevConsoleProcessor {
    @BuildStep(onlyIf={IsDevelopment.class})
    public DevConsoleRuntimeTemplateInfoBuildItem collectBeanInfo(FlywayProcessor.MigrationStateBuildItem migrationStateBuildItem, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        return new DevConsoleRuntimeTemplateInfoBuildItem("containers", (Supplier)new FlywayContainersSupplier(), this.getClass(), curateOutcomeBuildItem);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT, optional=true)
    DevConsoleRouteBuildItem invokeEndpoint(FlywayDevConsoleRecorder recorder) {
        return new DevConsoleRouteBuildItem("datasources", "POST", recorder.datasourcesHandler());
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT, optional=true)
    DevConsoleRouteBuildItem invokeEndpoint(FlywayDevConsoleRecorder recorder, List<JdbcInitialSQLGeneratorBuildItem> generatorBuildItem, FlywayBuildTimeConfig buildTimeConfig, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        HashMap<String, Supplier> initialSqlSuppliers = new HashMap<String, Supplier>();
        for (JdbcInitialSQLGeneratorBuildItem buildItem : generatorBuildItem) {
            initialSqlSuppliers.put(buildItem.getDatabaseName(), buildItem.getSqlSupplier());
        }
        return new DevConsoleRouteBuildItem("create-initial-migration", "POST", recorder.createInitialMigrationHandler(buildTimeConfig, curateOutcomeBuildItem.getApplicationModel().getAppArtifact().getArtifactId(), initialSqlSuppliers, ConfigUtils.isPropertyPresent((String)"quarkus.flyway.baseline-on-migrate"), ConfigUtils.isPropertyPresent((String)"quarkus.flyway.migrate-at-start"), ConfigUtils.isPropertyPresent((String)"quarkus.flyway.clean-at-start")));
    }
}

