/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.flyway.runtime.FlywayBuildTimeConfig;
import io.quarkus.flyway.runtime.FlywayDataSourceBuildTimeConfig;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.flywaydb.core.api.callback.Callback;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;

class FlywayCallbacksLocator {
    private final Collection<String> dataSourceNames;
    private final FlywayBuildTimeConfig flywayBuildConfig;
    private final CombinedIndexBuildItem combinedIndexBuildItem;
    private final BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer;

    private FlywayCallbacksLocator(Collection<String> dataSourceNames, FlywayBuildTimeConfig flywayBuildConfig, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer) {
        this.dataSourceNames = dataSourceNames;
        this.flywayBuildConfig = flywayBuildConfig;
        this.combinedIndexBuildItem = combinedIndexBuildItem;
        this.reflectiveClassProducer = reflectiveClassProducer;
    }

    public static FlywayCallbacksLocator with(Collection<String> dataSourceNames, FlywayBuildTimeConfig flywayBuildConfig, CombinedIndexBuildItem combinedIndexBuildItem, BuildProducer<ReflectiveClassBuildItem> reflectiveClassProducer) {
        return new FlywayCallbacksLocator(dataSourceNames, flywayBuildConfig, combinedIndexBuildItem, reflectiveClassProducer);
    }

    public Map<String, Collection<Callback>> getCallbacks() throws ClassNotFoundException, InvocationTargetException, InstantiationException, IllegalAccessException {
        HashMap<String, Collection<Callback>> callbacks = new HashMap<String, Collection<Callback>>();
        for (String dataSourceName : this.dataSourceNames) {
            Collection<Callback> instances = this.callbacksForDataSource(dataSourceName);
            callbacks.put(dataSourceName, instances);
        }
        return callbacks;
    }

    private Collection<Callback> callbacksForDataSource(String dataSourceName) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Optional callbackConfig = ((FlywayDataSourceBuildTimeConfig)this.flywayBuildConfig.datasources().get(dataSourceName)).callbacks();
        if (!callbackConfig.isPresent()) {
            return Collections.emptyList();
        }
        Collection callbacks = (Collection)callbackConfig.get();
        ArrayList<Callback> instances = new ArrayList<Callback>(callbacks.size());
        for (String callback : callbacks) {
            ClassInfo clazz = this.combinedIndexBuildItem.getIndex().getClassByName(DotName.createSimple((String)callback));
            Objects.requireNonNull(clazz, "Flyway callback not found, please verify the fully qualified name for the class: " + callback);
            if (Modifier.isAbstract(clazz.flags()) || !clazz.hasNoArgsConstructor()) {
                throw new IllegalArgumentException("Invalid Flyway callback. It shouldn't be abstract and must have a default constructor");
            }
            Class<?> clazzType = Class.forName(callback, false, Thread.currentThread().getContextClassLoader());
            Callback instance = (Callback)clazzType.getConstructors()[0].newInstance(new Object[0]);
            instances.add(instance);
            this.reflectiveClassProducer.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{clazz.name().toString()}).build());
        }
        return instances;
    }
}

