/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime.bindings.knative.events;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import io.quarkus.funqy.knative.events.AbstractCloudEvent;
import io.quarkus.funqy.knative.events.CloudEvent;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

class JsonCloudEventImpl<T>
extends AbstractCloudEvent<T>
implements CloudEvent<T> {
    String id;
    String specVersion;
    String source;
    String type;
    String subject;
    OffsetDateTime time;
    Map<String, String> extensions;
    String dataSchema;
    String dataContentType;
    T data;
    final JsonNode event;
    final ObjectMapper mapper;
    final Type dataType;
    private ObjectReader reader;
    private static final Set<String> reservedAttributes;

    public JsonCloudEventImpl(JsonNode event, Type dataType, ObjectMapper mapper, ObjectReader reader) {
        this.event = event;
        this.mapper = mapper;
        this.dataType = dataType;
        this.reader = reader;
    }

    @Override
    public String id() {
        JsonNode id;
        if (this.id == null && (id = this.event.get("id")) != null) {
            this.id = id.asText();
        }
        return this.id;
    }

    @Override
    public String specVersion() {
        JsonNode specVersion;
        if (this.specVersion == null && (specVersion = this.event.get("specversion")) != null) {
            this.specVersion = specVersion.asText();
        }
        return this.specVersion;
    }

    @Override
    public String source() {
        if (this.source == null && this.event.has("source")) {
            this.source = this.event.get("source").asText();
        }
        return this.source;
    }

    @Override
    public String type() {
        JsonNode source;
        if (this.type == null && (source = this.event.get("type")) != null) {
            this.type = source.asText();
        }
        return this.type;
    }

    @Override
    public String subject() {
        JsonNode subject;
        if (this.subject == null && (subject = this.event.get("subject")) != null) {
            this.subject = subject.asText();
        }
        return this.subject;
    }

    @Override
    public OffsetDateTime time() {
        JsonNode time;
        if (this.time == null && (time = this.event.get("time")) != null) {
            this.time = OffsetDateTime.parse(time.asText());
        }
        return this.time;
    }

    @Override
    public Map<String, String> extensions() {
        if (this.extensions == null) {
            this.extensions = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            this.event.fields().forEachRemaining(e -> {
                if (!reservedAttributes.contains(e.getKey())) {
                    this.extensions.put((String)e.getKey(), ((JsonNode)e.getValue()).textValue());
                }
            });
            this.extensions = Collections.unmodifiableMap(this.extensions);
        }
        return this.extensions;
    }

    @Override
    public String dataSchema() {
        String dsName;
        JsonNode dataSchema;
        if (this.dataSchema == null && (dataSchema = this.event.get(dsName = this.majorSpecVersion() == 0 ? "schemaurl" : "dataschema")) != null) {
            this.dataSchema = dataSchema.asText();
        }
        return this.dataSchema;
    }

    @Override
    public String dataContentType() {
        JsonNode dataContentType;
        if (this.dataContentType == null && (dataContentType = this.event.get("datacontenttype")) != null) {
            this.dataContentType = dataContentType.asText();
        }
        return this.dataContentType;
    }

    @Override
    public T data() {
        if (this.data != null) {
            return this.data;
        }
        if ((this.dataContentType() == null || this.dataContentType().startsWith("application/json")) && !byte[].class.equals((Object)this.dataType)) {
            try {
                this.data = this.reader.readValue(this.event.get("data"));
                return this.data;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (byte[].class.equals((Object)this.dataType)) {
            try {
                if (this.majorSpecVersion() == 0) {
                    boolean isBase64 = false;
                    if (this.event.has("datacontentencoding")) {
                        String dce = this.event.get("datacontentencoding").asText();
                        if ("base64".equals(dce)) {
                            isBase64 = true;
                        } else {
                            throw new RuntimeException("Cannot deserialize data for data-content-encoding: '" + dce + "'.");
                        }
                    }
                    if (isBase64) {
                        if (this.event.has("data")) {
                            String txt = this.event.get("data").asText();
                            this.data = (T)Base64.getDecoder().decode(txt);
                            return this.data;
                        }
                        return null;
                    }
                    if (this.event.has("data")) {
                        this.data = (T)this.mapper.writeValueAsBytes((Object)this.event.get("data"));
                        return this.data;
                    }
                    return null;
                }
                if (this.event.has("data")) {
                    this.data = (T)this.mapper.writeValueAsBytes((Object)this.event.get("data"));
                    return this.data;
                }
                if (this.event.has("data_base64")) {
                    String txt = this.event.get("data_base64").asText();
                    this.data = (T)Base64.getDecoder().decode(txt);
                    return this.data;
                }
                return null;
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        String msg = String.format("Don't know how to get event data (dataContentType: '%s', javaType: '%s').", this.dataContentType(), this.dataType.getTypeName());
        throw new RuntimeException(msg);
    }

    static {
        TreeSet<String> ra = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        ra.add("specversion");
        ra.add("id");
        ra.add("source");
        ra.add("type");
        ra.add("datacontenttype");
        ra.add("subject");
        ra.add("time");
        ra.add("datacontentencoding");
        ra.add("schemaurl");
        ra.add("dataschema");
        ra.add("data");
        reservedAttributes = Collections.unmodifiableSet(ra);
    }
}

