/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.knative.events;

import io.quarkus.funqy.knative.events.AbstractCloudEvent;
import io.quarkus.funqy.knative.events.CloudEvent;
import java.time.OffsetDateTime;
import java.util.Collections;
import java.util.Map;

public class CloudEventBuilder {
    private String specVersion;
    private String id;
    private String type;
    private String source;
    private String subject;
    private OffsetDateTime time;
    private String dataSchema;
    private Map<String, String> extensions;

    private CloudEventBuilder() {
    }

    public static CloudEventBuilder create() {
        return new CloudEventBuilder();
    }

    public CloudEventBuilder specVersion(String specVersion) {
        if (specVersion.charAt(0) != '0' && specVersion.charAt(0) != '1' || specVersion.charAt(1) != '.') {
            throw new IllegalArgumentException("Only supported major versions are 0 and 1.");
        }
        this.specVersion = specVersion;
        return this;
    }

    public CloudEventBuilder id(String id) {
        this.id = id;
        return this;
    }

    public CloudEventBuilder type(String type) {
        this.type = type;
        return this;
    }

    public CloudEventBuilder source(String source) {
        this.source = source;
        return this;
    }

    public CloudEventBuilder subject(String subject) {
        this.subject = subject;
        return this;
    }

    public CloudEventBuilder time(OffsetDateTime time) {
        this.time = time;
        return this;
    }

    public CloudEventBuilder dataSchema(String dataSchema) {
        this.dataSchema = dataSchema;
        return this;
    }

    public CloudEventBuilder extensions(Map<String, String> extensions) {
        this.extensions = extensions;
        return this;
    }

    public CloudEvent<byte[]> build(byte[] data, String dataContentType) {
        return new SimpleCloudEvent<byte[]>(this.specVersion, this.id, this.type, this.source, this.subject, this.time, this.extensions, this.dataSchema, dataContentType, data);
    }

    public <T> CloudEvent<T> build(T data) {
        return new SimpleCloudEvent<T>(this.specVersion, this.id, this.type, this.source, this.subject, this.time, this.extensions, this.dataSchema, "application/json", data);
    }

    public CloudEvent<Void> build() {
        return new SimpleCloudEvent<Object>(this.specVersion, this.id, this.type, this.source, this.subject, this.time, this.extensions, this.dataSchema, null, null);
    }

    private static final class SimpleCloudEvent<T>
    extends AbstractCloudEvent<T>
    implements CloudEvent<T> {
        private final String specVersion;
        private final String id;
        private final String type;
        private final String source;
        private final String subject;
        private final OffsetDateTime time;
        private final Map<String, String> extensions;
        private final String dataSchema;
        private final String dataContentType;
        private final T data;

        SimpleCloudEvent(String specVersion, String id, String type, String source, String subject, OffsetDateTime time, Map<String, String> extensions, String dataSchema, String dataContentType, T data) {
            this.extensions = extensions == null ? Collections.emptyMap() : Collections.unmodifiableMap(extensions);
            this.specVersion = specVersion;
            this.id = id;
            this.type = type;
            this.source = source;
            this.subject = subject;
            this.time = time;
            this.dataSchema = dataSchema;
            this.dataContentType = dataContentType;
            this.data = data;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String specVersion() {
            return this.specVersion;
        }

        @Override
        public String source() {
            return this.source;
        }

        @Override
        public String type() {
            return this.type;
        }

        @Override
        public String subject() {
            return this.subject;
        }

        @Override
        public OffsetDateTime time() {
            return this.time;
        }

        @Override
        public String dataSchema() {
            return this.dataSchema;
        }

        @Override
        public Map<String, String> extensions() {
            return this.extensions;
        }

        @Override
        public String dataContentType() {
            return this.dataContentType;
        }

        @Override
        public T data() {
            return this.data;
        }
    }
}

