/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.runtime.bindings.knative.events.filters;

import io.quarkus.funqy.knative.events.CloudEvent;
import java.util.function.Predicate;

public class CEAttributeLiteralEqualsFilter
implements Predicate<CloudEvent> {
    private String attributeName;
    private String expectedValue;

    public CEAttributeLiteralEqualsFilter(String attributeName, String expectedValue) {
        this.attributeName = attributeName;
        this.expectedValue = expectedValue;
    }

    @Override
    public boolean test(CloudEvent event) {
        String value;
        CloudEvent ceEvent = event;
        switch (this.attributeName) {
            case "id": {
                value = ceEvent.id();
                break;
            }
            case "source": {
                value = ceEvent.source();
                break;
            }
            case "type": {
                value = ceEvent.type();
                break;
            }
            case "subject": {
                value = ceEvent.subject();
                break;
            }
            default: {
                value = ceEvent.extensions().get(this.attributeName);
            }
        }
        if (value == null) {
            return false;
        }
        return value.equals(this.expectedValue);
    }

    public String toString() {
        return "[attributeName=" + this.attributeName + ", expectedValue='" + this.expectedValue + "']";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeName == null ? 0 : this.attributeName.hashCode());
        result = 31 * result + (this.expectedValue == null ? 0 : this.expectedValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CEAttributeLiteralEqualsFilter other = (CEAttributeLiteralEqualsFilter)obj;
        if (this.attributeName == null ? other.attributeName != null : !this.attributeName.equals(other.attributeName)) {
            return false;
        }
        return !(this.expectedValue == null ? other.expectedValue != null : !this.expectedValue.equals(other.expectedValue));
    }
}

