/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.deployment;

import io.quarkus.arc.deployment.AnnotationsTransformerBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.processor.AnnotationsTransformer;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.processor.Transformation;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.BytecodeTransformerBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveHierarchyBuildItem;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.funqy.Context;
import io.quarkus.funqy.Funq;
import io.quarkus.funqy.deployment.FunctionBuildItem;
import io.quarkus.funqy.deployment.FunctionInitializedBuildItem;
import io.quarkus.funqy.deployment.ReflectionRegistrationUtil;
import io.quarkus.funqy.runtime.FunctionRecorder;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class FunctionScannerBuildStep {
    public static final DotName FUNQ = DotName.createSimple((String)Funq.class.getName());
    public static final DotName CONTEXT = DotName.createSimple((String)Context.class.getName());

    @BuildStep
    public void scanFunctions(BeanArchiveIndexBuildItem beanArchiveIndexBuildItem, BuildProducer<BytecodeTransformerBuildItem> transformers, BuildProducer<AnnotationsTransformerBuildItem> annotationsTransformer, BuildProducer<UnremovableBeanBuildItem> unremovableBeans, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ReflectiveHierarchyBuildItem> reflectiveHierarchy, BuildProducer<FunctionBuildItem> functions) {
        IndexView index = beanArchiveIndexBuildItem.getIndex();
        Collection funqs = index.getAnnotations(FUNQ);
        final HashSet<ClassInfo> classes = new HashSet<ClassInfo>();
        HashSet<String> classNames = new HashSet<String>();
        for (AnnotationInstance funqMethod : funqs) {
            MethodInfo method = funqMethod.target().asMethod();
            String className = method.declaringClass().name().toString();
            classNames.add(className);
            classes.add(method.declaringClass());
            String methodName = method.name();
            if (!Modifier.isPublic(method.flags())) {
                throw new RuntimeException(String.format("Method '%s' annotated with '@Funq' declared in the class '%s' is not public.", methodName, className));
            }
            String functionName = null;
            if (funqMethod.value() != null) {
                functionName = funqMethod.value().asString();
            }
            if (functionName != null && functionName.isEmpty()) {
                functionName = null;
            }
            functions.produce((BuildItem)new FunctionBuildItem(className, methodName, method.descriptor(), functionName));
            String source = FunctionScannerBuildStep.class.getSimpleName() + " > " + method.declaringClass() + "[" + method + "]";
            Type returnType = method.returnType();
            if (returnType.kind() != Type.Kind.VOID) {
                reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(returnType).index(index).ignoreTypePredicate((Predicate)ReflectionRegistrationUtil.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)ReflectionRegistrationUtil.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)ReflectionRegistrationUtil.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
            }
            for (short i = 0; i < method.parametersCount(); i = (short)(i + 1)) {
                Type parameterType = method.parameterType((int)i);
                if (FunctionScannerBuildStep.hasAnnotation(method, i, CONTEXT)) continue;
                reflectiveHierarchy.produce((BuildItem)new ReflectiveHierarchyBuildItem.Builder().type(parameterType).index(index).ignoreTypePredicate((Predicate)ReflectionRegistrationUtil.IGNORE_TYPE_FOR_REFLECTION_PREDICATE).ignoreFieldPredicate((Predicate)ReflectionRegistrationUtil.IGNORE_FIELD_FOR_REFLECTION_PREDICATE).ignoreMethodPredicate((Predicate)ReflectionRegistrationUtil.IGNORE_METHOD_FOR_REFLECTION_PREDICATE).source(source).build());
            }
        }
        HashSet<ClassInfo> withoutDefaultCtor = new HashSet<ClassInfo>();
        for (ClassInfo clazz : classes) {
            reflectiveClass.produce((BuildItem)ReflectiveClassBuildItem.builder((String[])new String[]{clazz.name().toString()}).methods().fields().build());
            if (clazz.hasNoArgsConstructor()) continue;
            withoutDefaultCtor.add(clazz);
        }
        unremovableBeans.produce((BuildItem)new UnremovableBeanBuildItem(b -> classNames.contains(b.getBeanClass().toString())));
        FunctionScannerBuildStep.generateDefaultConstructors(transformers, withoutDefaultCtor);
        annotationsTransformer.produce((BuildItem)new AnnotationsTransformerBuildItem(new AnnotationsTransformer(){

            public boolean appliesTo(AnnotationTarget.Kind kind) {
                return kind == AnnotationTarget.Kind.CLASS;
            }

            public void transform(AnnotationsTransformer.TransformationContext transformationContext) {
                ClassInfo clazz = transformationContext.getTarget().asClass();
                if (!classes.contains(clazz)) {
                    return;
                }
                if (BuiltinScope.isDeclaredOn((ClassInfo)clazz)) {
                    return;
                }
                Transformation transformation = transformationContext.transform();
                transformation.add(BuiltinScope.DEPENDENT.getName(), new AnnotationValue[0]);
                if (clazz.declaredAnnotation(DotNames.TYPED) == null) {
                    transformation.add(FunctionScannerBuildStep.this.createTypedAnnotationInstance(clazz));
                }
                transformation.done();
            }
        }));
    }

    private static boolean hasAnnotation(MethodInfo method, short paramPosition, DotName annotation) {
        for (AnnotationInstance annotationInstance : method.annotations()) {
            AnnotationTarget target = annotationInstance.target();
            if (target == null || target.kind() != AnnotationTarget.Kind.METHOD_PARAMETER || target.asMethodParameter().position() != paramPosition || !annotationInstance.name().equals((Object)annotation)) continue;
            return true;
        }
        return false;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public FunctionInitializedBuildItem staticInit(FunctionRecorder recorder, List<FunctionBuildItem> functions, RecorderContext context) {
        if (functions == null || functions.isEmpty()) {
            return null;
        }
        recorder.init();
        for (FunctionBuildItem function : functions) {
            if (function.getFunctionName() == null) {
                recorder.register(context.classProxy(function.getClassName()), function.getMethodName(), function.getDescriptor());
                continue;
            }
            recorder.register(context.classProxy(function.getClassName()), function.getMethodName(), function.getDescriptor(), function.getFunctionName());
        }
        return FunctionInitializedBuildItem.SINGLETON;
    }

    private static void generateDefaultConstructors(BuildProducer<BytecodeTransformerBuildItem> transformers, Set<ClassInfo> withoutDefaultCtor) {
        for (ClassInfo classInfo : withoutDefaultCtor) {
            BuiltinScope scope = BuiltinScope.from((ClassInfo)classInfo);
            if (scope != null && scope.getInfo().isNormal()) continue;
            if (classInfo.superClassType() == null || !classInfo.superClassType().name().equals((Object)DotNames.OBJECT)) {
                return;
            }
            String name = classInfo.name().toString();
            transformers.produce((BuildItem)new BytecodeTransformerBuildItem(name, (BiFunction)new BiFunction<String, ClassVisitor, ClassVisitor>(){

                @Override
                public ClassVisitor apply(String className, ClassVisitor classVisitor) {
                    ClassVisitor cv = new ClassVisitor(589824, classVisitor){

                        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                            super.visit(version, access, name, signature, superName, interfaces);
                            MethodVisitor ctor = this.visitMethod(4097, "<init>", "()V", null, null);
                            ctor.visitCode();
                            ctor.visitVarInsn(25, 0);
                            ctor.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
                            ctor.visitInsn(177);
                            ctor.visitMaxs(1, 1);
                            ctor.visitEnd();
                        }
                    };
                    return cv;
                }
            }));
        }
    }

    private AnnotationInstance createTypedAnnotationInstance(ClassInfo clazz) {
        return AnnotationInstance.create((DotName)DotNames.TYPED, (AnnotationTarget)clazz, (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createArrayValue((String)"value", (AnnotationValue[])new AnnotationValue[]{AnnotationValue.createClassValue((String)"value", (Type)Type.create((DotName)clazz.name(), (Type.Kind)Type.Kind.CLASS))})});
    }
}

