/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.dependency;

import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.bootstrap.model.PlatformImportsImpl;
import io.quarkus.bootstrap.resolver.AppModelResolverException;
import io.quarkus.gradle.dependency.ConditionalDependenciesEnabler;
import io.quarkus.gradle.tooling.ToolingUtils;
import io.quarkus.gradle.tooling.dependency.DependencyUtils;
import io.quarkus.gradle.tooling.dependency.ExtensionDependency;
import io.quarkus.runtime.LaunchMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dependencies.DefaultDependencyArtifact;
import org.gradle.api.internal.artifacts.dependencies.DefaultExternalModuleDependency;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;

public class ApplicationDeploymentClasspathBuilder {
    public static final String QUARKUS_BOOTSTRAP_RESOLVER_CONFIGURATION = "quarkusBootstrapResolverConfiguration";
    private static final String QUARKUS_PLATFORM_PROPERTIES = "quarkusPlatformProperties";
    private final Project project;
    private final LaunchMode mode;
    private final String runtimeConfigurationName;
    private final String platformConfigurationName;
    private final String deploymentConfigurationName;
    private final String compileOnlyConfigurationName;
    private static final HashMap<String, PlatformImportsImpl> platformImports = new HashMap();
    private final String platformImportName;
    private final List<Dependency> platformDataDeps = new ArrayList<Dependency>();

    private static String getLaunchModeAlias(LaunchMode mode) {
        if (mode == LaunchMode.DEVELOPMENT) {
            return "Dev";
        }
        if (mode == LaunchMode.TEST) {
            return "Test";
        }
        return "Prod";
    }

    private static String getRuntimeConfigName(LaunchMode mode, boolean base) {
        StringBuilder sb = new StringBuilder();
        sb.append("quarkus").append(ApplicationDeploymentClasspathBuilder.getLaunchModeAlias(mode));
        if (base) {
            sb.append("Base");
        }
        sb.append("RuntimeClasspathConfiguration");
        return sb.toString();
    }

    public static String getBaseRuntimeConfigName(LaunchMode mode) {
        return ApplicationDeploymentClasspathBuilder.getRuntimeConfigName(mode, true);
    }

    public static String getFinalRuntimeConfigName(LaunchMode mode) {
        return ApplicationDeploymentClasspathBuilder.getRuntimeConfigName(mode, false);
    }

    public static void initConfigurations(Project project) {
        ConfigurationContainer configContainer = project.getConfigurations();
        configContainer.register("quarkusDev", config -> {
            config.extendsFrom(new Configuration[]{configContainer.getByName("implementation")});
            config.setCanBeConsumed(false);
        });
        configContainer.register(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(LaunchMode.TEST), config -> {
            config.extendsFrom(new Configuration[]{configContainer.getByName("testRuntimeClasspath")});
            config.setCanBeConsumed(false);
        });
        configContainer.register(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(LaunchMode.NORMAL), config -> {
            config.extendsFrom(new Configuration[]{configContainer.getByName("runtimeClasspath")});
            config.setCanBeConsumed(false);
        });
        configContainer.register(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(LaunchMode.DEVELOPMENT), config -> {
            config.extendsFrom(new Configuration[]{configContainer.getByName("quarkusDev"), configContainer.getByName("compileClasspath"), configContainer.getByName("runtimeClasspath")});
            config.setCanBeConsumed(false);
        });
    }

    private static Configuration[] getOriginalRuntimeClasspaths(Project project, LaunchMode mode) {
        List<String> configurationNames = switch (mode) {
            case LaunchMode.TEST -> List.of("testRuntimeClasspath");
            case LaunchMode.NORMAL -> List.of("runtimeClasspath");
            case LaunchMode.DEVELOPMENT -> List.of("quarkusDev", "compileClasspath", "runtimeClasspath");
            default -> throw new IllegalArgumentException("Unexpected mode: " + String.valueOf(mode));
        };
        ConfigurationContainer configContainer = project.getConfigurations();
        return (Configuration[])configurationNames.stream().map(arg_0 -> ((ConfigurationContainer)configContainer).getByName(arg_0)).toArray(Configuration[]::new);
    }

    public ApplicationDeploymentClasspathBuilder(Project project, LaunchMode mode) {
        this.project = project;
        this.mode = mode;
        this.runtimeConfigurationName = ApplicationDeploymentClasspathBuilder.getFinalRuntimeConfigName(mode);
        this.platformConfigurationName = ToolingUtils.toPlatformConfigurationName(this.runtimeConfigurationName);
        this.deploymentConfigurationName = ToolingUtils.toDeploymentConfigurationName(this.runtimeConfigurationName);
        this.platformImportName = project.getPath() + ":" + this.platformConfigurationName;
        this.compileOnlyConfigurationName = "quarkus" + ApplicationDeploymentClasspathBuilder.getLaunchModeAlias(mode) + "CompileOnlyConfiguration";
        this.setUpPlatformConfiguration();
        this.setUpPlatformPropertiesConfiguration();
        this.setUpRuntimeConfiguration();
        this.setUpDeploymentConfiguration();
        this.setUpCompileOnlyConfiguration();
    }

    private void setUpPlatformConfiguration() {
        if (this.project.getConfigurations().findByName(this.platformConfigurationName) == null) {
            this.project.getConfigurations().register(this.platformConfigurationName, configuration -> {
                configuration.setCanBeConsumed(false);
                ListProperty dependencyListProperty = this.project.getObjects().listProperty(Dependency.class);
                configuration.getDependencies().addAllLater((Provider)dependencyListProperty.value(this.project.provider(() -> this.project.getConfigurations().getByName("implementation").getAllDependencies().stream().filter(dependency -> dependency instanceof ModuleDependency && ToolingUtils.isEnforcedPlatform((ModuleDependency)dependency)).collect(Collectors.toList()))));
                PlatformImportsImpl platformImports = platformImports.computeIfAbsent(this.platformImportName, ignored -> new PlatformImportsImpl());
                configuration.getResolutionStrategy().eachDependency(d -> {
                    ModuleIdentifier identifier = d.getTarget().getModule();
                    String name = identifier.getName();
                    if (name.endsWith("-quarkus-platform-descriptor")) {
                        this.platformDataDeps.add(ApplicationDeploymentClasspathBuilder.toDependency(d.getTarget(), d.getTarget().getVersion(), "json"));
                        platformImports.addPlatformDescriptor(identifier.getGroup(), name, d.getTarget().getVersion(), "json", d.getTarget().getVersion());
                    } else if (name.endsWith("-quarkus-platform-properties")) {
                        Dependency gradleDep = ApplicationDeploymentClasspathBuilder.toDependency(d.getTarget(), "", "properties");
                        this.platformDataDeps.add(gradleDep);
                        for (ResolvedArtifact a : this.project.getConfigurations().detachedConfiguration(new Dependency[]{gradleDep}).getResolvedConfiguration().getResolvedArtifacts()) {
                            if (!a.getName().equals(name)) continue;
                            try {
                                platformImports.addPlatformProperties(identifier.getGroup(), name, null, "properties", d.getTarget().getVersion(), a.getFile().toPath());
                                break;
                            }
                            catch (AppModelResolverException e) {
                                throw new GradleException("Failed to import platform properties " + String.valueOf(a.getFile()), (Throwable)e);
                            }
                        }
                    }
                });
            });
        }
    }

    private static Dependency toDependency(ModuleVersionSelector versionSelector, String classifier, String type) {
        DefaultDependencyArtifact dep = new DefaultDependencyArtifact();
        dep.setExtension(type);
        dep.setType(type);
        if (classifier != null) {
            dep.setClassifier(classifier);
        }
        dep.setName(versionSelector.getName());
        DefaultExternalModuleDependency gradleDep = new DefaultExternalModuleDependency(versionSelector.getGroup(), versionSelector.getName(), versionSelector.getVersion(), null);
        gradleDep.addArtifact((DependencyArtifact)dep);
        return gradleDep;
    }

    private void setUpPlatformPropertiesConfiguration() {
        if (!this.project.getConfigurations().getNames().contains(QUARKUS_PLATFORM_PROPERTIES)) {
            this.project.getConfigurations().register(QUARKUS_PLATFORM_PROPERTIES, config -> {
                config.setCanBeConsumed(false);
                config.setTransitive(false);
                ListProperty dependencyListProperty = this.project.getObjects().listProperty(Dependency.class);
                config.getDependencies().addAllLater((Provider)dependencyListProperty.value(this.project.provider(this::resolvePlatformDependencies)));
            });
        }
    }

    private List<Dependency> resolvePlatformDependencies() {
        this.getPlatformConfiguration().resolve();
        return this.platformDataDeps;
    }

    private void setUpRuntimeConfiguration() {
        if (!this.project.getConfigurations().getNames().contains(this.runtimeConfigurationName)) {
            this.project.getConfigurations().register(this.runtimeConfigurationName, configuration -> {
                configuration.setCanBeConsumed(false);
                configuration.extendsFrom(new Configuration[]{this.project.getConfigurations().getByName(ApplicationDeploymentClasspathBuilder.getBaseRuntimeConfigName(this.mode))});
            });
        }
    }

    private void setUpDeploymentConfiguration() {
        if (!this.project.getConfigurations().getNames().contains(this.deploymentConfigurationName)) {
            this.project.getConfigurations().register(this.deploymentConfigurationName, configuration -> {
                configuration.setCanBeConsumed(false);
                Configuration enforcedPlatforms = this.getPlatformConfiguration();
                configuration.extendsFrom(new Configuration[]{enforcedPlatforms});
                HashMap calculatedDependenciesByModeAndConfiguration = new HashMap();
                ListProperty dependencyListProperty = this.project.getObjects().listProperty(Dependency.class);
                configuration.getDependencies().addAllLater((Provider)dependencyListProperty.value(this.project.provider(() -> {
                    String key = String.format("%s%s%s", this.mode, configuration.getName(), this.project.getName());
                    if (!calculatedDependenciesByModeAndConfiguration.containsKey(key)) {
                        ConditionalDependenciesEnabler cdEnabler = new ConditionalDependenciesEnabler(this.project, this.mode, enforcedPlatforms);
                        Collection<ExtensionDependency<?>> allExtensions = cdEnabler.getAllExtensions();
                        Set<ExtensionDependency<?>> extensions = this.collectFirstMetQuarkusExtensions(this.getRawRuntimeConfiguration(), allExtensions);
                        for (ExtensionDependency<?> knownExtension : allExtensions) {
                            if (!knownExtension.isConditional()) continue;
                            extensions.add(knownExtension);
                        }
                        HashSet<ModuleVersionIdentifier> alreadyProcessed = new HashSet<ModuleVersionIdentifier>(extensions.size());
                        DependencyHandler dependencies = this.project.getDependencies();
                        HashSet<Dependency> deploymentDependencies = new HashSet<Dependency>();
                        for (ExtensionDependency<?> extension : extensions) {
                            if (!alreadyProcessed.add(extension.getExtensionId())) continue;
                            deploymentDependencies.add(DependencyUtils.createDeploymentDependency(dependencies, extension));
                        }
                        calculatedDependenciesByModeAndConfiguration.put(key, deploymentDependencies);
                        return deploymentDependencies;
                    }
                    return (Set)calculatedDependenciesByModeAndConfiguration.get(key);
                })));
            });
        }
    }

    private void setUpCompileOnlyConfiguration() {
        if (!this.project.getConfigurations().getNames().contains(this.compileOnlyConfigurationName)) {
            this.project.getConfigurations().register(this.compileOnlyConfigurationName, config -> {
                config.extendsFrom(new Configuration[]{this.project.getConfigurations().getByName(this.platformConfigurationName), this.project.getConfigurations().getByName("compileOnly")});
                config.shouldResolveConsistentlyWith(this.getDeploymentConfiguration());
                config.setCanBeConsumed(false);
            });
        }
    }

    public FileCollection getOriginalRuntimeClasspathAsInput() {
        return this.project.files((Object[])ApplicationDeploymentClasspathBuilder.getOriginalRuntimeClasspaths(this.project, this.mode));
    }

    public Configuration getPlatformConfiguration() {
        return this.project.getConfigurations().getByName(this.platformConfigurationName);
    }

    public Configuration getPlatformPropertiesConfiguration() {
        return this.project.getConfigurations().getByName(QUARKUS_PLATFORM_PROPERTIES);
    }

    public Configuration getRawRuntimeConfiguration() {
        return this.project.getConfigurations().getByName(this.runtimeConfigurationName);
    }

    public Configuration getRuntimeConfiguration() {
        this.getDeploymentConfiguration().resolve();
        return this.project.getConfigurations().getByName(this.runtimeConfigurationName);
    }

    public Configuration getRuntimeConfigurationWithoutResolvingDeployment() {
        return this.project.getConfigurations().getByName(this.runtimeConfigurationName);
    }

    public Configuration getDeploymentConfiguration() {
        return this.project.getConfigurations().getByName(this.deploymentConfigurationName);
    }

    public Configuration getCompileOnly() {
        this.getDeploymentConfiguration().resolve();
        return this.project.getConfigurations().getByName(this.compileOnlyConfigurationName);
    }

    public PlatformImports getPlatformImports() {
        this.getPlatformConfiguration().getResolvedConfiguration();
        return (PlatformImports)platformImports.get(this.platformImportName);
    }

    private Set<ExtensionDependency<?>> collectFirstMetQuarkusExtensions(Configuration configuration, Collection<ExtensionDependency<?>> knownExtensions) {
        HashSet firstLevelExtensions = new HashSet();
        Set firstLevelModuleDependencies = configuration.getResolvedConfiguration().getFirstLevelModuleDependencies();
        HashSet<String> visitedArtifacts = new HashSet<String>();
        for (ResolvedDependency firstLevelModuleDependency : firstLevelModuleDependencies) {
            firstLevelExtensions.addAll(this.collectQuarkusExtensions(firstLevelModuleDependency, visitedArtifacts, knownExtensions));
        }
        return firstLevelExtensions;
    }

    private Set<ExtensionDependency<?>> collectQuarkusExtensions(ResolvedDependency dependency, Set<String> visitedArtifacts, Collection<ExtensionDependency<?>> knownExtensions) {
        String artifactKey = String.format("%s:%s", dependency.getModuleGroup(), dependency.getModuleName());
        if (!visitedArtifacts.add(artifactKey)) {
            return Collections.emptySet();
        }
        LinkedHashSet extensions = new LinkedHashSet();
        ExtensionDependency<?> extension = this.getExtensionOrNull(dependency.getModuleGroup(), dependency.getModuleName(), dependency.getModuleVersion(), knownExtensions);
        if (extension != null) {
            extensions.add(extension);
        } else {
            for (ResolvedDependency child : dependency.getChildren()) {
                extensions.addAll(this.collectQuarkusExtensions(child, visitedArtifacts, knownExtensions));
            }
        }
        return extensions;
    }

    private ExtensionDependency<?> getExtensionOrNull(String group, String artifact, String version, Collection<ExtensionDependency<?>> knownExtensions) {
        for (ExtensionDependency<?> knownExtension : knownExtensions) {
            if (!group.equals(knownExtension.getGroup()) || !artifact.equals(knownExtension.getName()) || !version.equals(knownExtension.getVersion())) continue;
            return knownExtension;
        }
        return null;
    }
}

