/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gradle.tooling;

import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.DefaultArtifactSources;
import io.quarkus.bootstrap.workspace.LazySourceDir;
import io.quarkus.bootstrap.workspace.WorkspaceModule;
import io.quarkus.bootstrap.workspace.WorkspaceModuleId;
import io.quarkus.gradle.tooling.DefaultProjectDescriptor;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.file.copy.CopySpecInternal;
import org.gradle.api.internal.file.copy.DefaultCopySpec;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.testing.Test;

public class ProjectDescriptorBuilder {
    private final WorkspaceModule.Mutable moduleBuilder;

    public static Provider<DefaultProjectDescriptor> buildForApp(Project project) {
        ProjectDescriptorBuilder builder = new ProjectDescriptorBuilder(project);
        project.afterEvaluate(evaluated -> ProjectDescriptorBuilder.initSourceDirs(evaluated, builder.moduleBuilder));
        return project.getProviders().provider(() -> new DefaultProjectDescriptor(builder.moduleBuilder));
    }

    public static void initSourceDirs(Project project, WorkspaceModule.Mutable result) {
        SourceSetContainer srcSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        project.getTasks().withType(Jar.class).configureEach(jarTask -> {
            String classifier = (String)jarTask.getArchiveClassifier().get();
            ArrayList<File> classesDirs = new ArrayList<File>(2);
            ArrayList<File> resourcesOutputDirs = new ArrayList<File>(2);
            ProjectDescriptorBuilder.collectSourceSetOutput((DefaultCopySpec)jarTask.getRootSpec(), classesDirs, resourcesOutputDirs);
            ArrayList<LazySourceDir> sourceDirs = new ArrayList<LazySourceDir>();
            ArrayList<LazySourceDir> resourceDirs = new ArrayList<LazySourceDir>(2);
            for (SourceSet srcSet : srcSets) {
                for (File classesDir : srcSet.getOutput().getClassesDirs().getFiles()) {
                    if (!classesDirs.contains(classesDir)) continue;
                    for (File srcDir : srcSet.getAllJava().getSrcDirs()) {
                        sourceDirs.add(new LazySourceDir(srcDir.toPath(), classesDir.toPath()));
                    }
                }
                if (!resourcesOutputDirs.contains(srcSet.getOutput().getResourcesDir())) continue;
                Path resourcesTarget = srcSet.getOutput().getResourcesDir().toPath();
                for (File dir : srcSet.getResources().getSrcDirs()) {
                    resourceDirs.add(new LazySourceDir(dir.toPath(), resourcesTarget));
                }
            }
            if (!sourceDirs.isEmpty() || !resourceDirs.isEmpty()) {
                result.addArtifactSources((ArtifactSources)new DefaultArtifactSources(classifier, sourceDirs, resourceDirs));
            }
        });
        project.getTasks().withType(Test.class).configureEach(testTask -> {
            for (SourceSet srcSet : srcSets) {
                String classifier = null;
                List testSourcesDirs = Collections.emptyList();
                List testResourcesDirs = Collections.emptyList();
                for (File classesDir : srcSet.getOutput().getClassesDirs().getFiles()) {
                    if (!testTask.getTestClassesDirs().contains(classesDir)) continue;
                    if (classifier == null && result.hasSources(classifier = ProjectDescriptorBuilder.sourceSetNameToClassifier(srcSet.getName()))) break;
                    for (File srcDir : srcSet.getAllJava().getSrcDirs()) {
                        if (testSourcesDirs.isEmpty()) {
                            testSourcesDirs = new ArrayList(6);
                        }
                        testSourcesDirs.add(new LazySourceDir(srcDir.toPath(), classesDir.toPath()));
                    }
                }
                if (classifier == null || testSourcesDirs.isEmpty()) continue;
                if (srcSet.getOutput().getResourcesDir() != null) {
                    Path resourcesOutputDir = srcSet.getOutput().getResourcesDir().toPath();
                    for (File dir : srcSet.getResources().getSrcDirs()) {
                        if (testResourcesDirs.isEmpty()) {
                            testResourcesDirs = new ArrayList(2);
                        }
                        testResourcesDirs.add(new LazySourceDir(dir.toPath(), resourcesOutputDir));
                    }
                }
                result.addArtifactSources((ArtifactSources)new DefaultArtifactSources(classifier, testSourcesDirs, testResourcesDirs));
            }
        });
    }

    private static String sourceSetNameToClassifier(String sourceSetName) {
        if ("test".equals(sourceSetName)) {
            return "tests";
        }
        StringBuilder sb = new StringBuilder(sourceSetName.length() + 2);
        for (int i = 0; i < sourceSetName.length(); ++i) {
            char lowerCase;
            char original = sourceSetName.charAt(i);
            if (original != (lowerCase = Character.toLowerCase(original))) {
                sb.append('-');
            }
            sb.append(lowerCase);
        }
        return sb.toString();
    }

    private static void collectSourceSetOutput(DefaultCopySpec spec, List<File> classesDir, List<File> resourcesDir) {
        for (Object paths : spec.getSourcePaths()) {
            if (!(paths instanceof SourceSetOutput)) continue;
            SourceSetOutput sso = (SourceSetOutput)paths;
            classesDir.addAll(sso.getClassesDirs().getFiles());
            resourcesDir.add(sso.getResourcesDir());
        }
        for (CopySpecInternal child : spec.getChildren()) {
            ProjectDescriptorBuilder.collectSourceSetOutput((DefaultCopySpec)child, classesDir, resourcesDir);
        }
    }

    private ProjectDescriptorBuilder(Project project) {
        this.moduleBuilder = WorkspaceModule.builder().setModuleId(WorkspaceModuleId.of((String)String.valueOf(project.getGroup()), (String)project.getName(), (String)String.valueOf(project.getVersion()))).setModuleDir(project.getLayout().getProjectDirectory().getAsFile().toPath()).setBuildDir(((Directory)project.getLayout().getBuildDirectory().get()).getAsFile().toPath()).setBuildFile(project.getBuildFile().toPath());
    }
}

