/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.reflection.service;

import com.google.protobuf.Descriptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.grpc.reflection.v1.ErrorResponse;
import io.grpc.reflection.v1.ExtensionNumberResponse;
import io.grpc.reflection.v1.ExtensionRequest;
import io.grpc.reflection.v1.FileDescriptorResponse;
import io.grpc.reflection.v1.ListServiceResponse;
import io.grpc.reflection.v1.MutinyServerReflectionGrpc;
import io.grpc.reflection.v1.ServerReflectionRequest;
import io.grpc.reflection.v1.ServerReflectionResponse;
import io.grpc.reflection.v1.ServiceResponse;
import io.quarkus.grpc.reflection.service.GrpcServerIndex;
import io.smallrye.mutiny.Multi;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ReflectionServiceV1
extends MutinyServerReflectionGrpc.ServerReflectionImplBase {
    private final GrpcServerIndex index;

    public ReflectionServiceV1(List<ServerServiceDefinition> definitions) {
        this.index = new GrpcServerIndex(definitions);
    }

    public Multi<ServerReflectionResponse> serverReflectionInfo(Multi<ServerReflectionRequest> request) {
        return request.onItem().transform((Function)new Function<ServerReflectionRequest, ServerReflectionResponse>(){

            @Override
            public ServerReflectionResponse apply(ServerReflectionRequest req) {
                switch (req.getMessageRequestCase()) {
                    case LIST_SERVICES: {
                        return ReflectionServiceV1.this.getServiceList(req);
                    }
                    case FILE_BY_FILENAME: {
                        return ReflectionServiceV1.this.getFileByName(req);
                    }
                    case FILE_CONTAINING_SYMBOL: {
                        return ReflectionServiceV1.this.getFileContainingSymbol(req);
                    }
                    case FILE_CONTAINING_EXTENSION: {
                        return ReflectionServiceV1.this.getFileByExtension(req);
                    }
                    case ALL_EXTENSION_NUMBERS_OF_TYPE: {
                        return ReflectionServiceV1.this.getAllExtensions(req);
                    }
                }
                return ReflectionServiceV1.this.getErrorResponse(req, Status.Code.UNIMPLEMENTED, "not implemented " + req.getMessageRequestCase());
            }
        });
    }

    private ServerReflectionResponse getServiceList(ServerReflectionRequest request) {
        ListServiceResponse response = this.index.getServiceNames().stream().map(new Function<String, ServiceResponse>(){

            @Override
            public ServiceResponse apply(String s) {
                return ServiceResponse.newBuilder().setName(s).build();
            }
        }).collect(new Supplier<ListServiceResponse.Builder>(){

            @Override
            public ListServiceResponse.Builder get() {
                return ListServiceResponse.newBuilder();
            }
        }, new BiConsumer<ListServiceResponse.Builder, ServiceResponse>(){

            @Override
            public void accept(ListServiceResponse.Builder builder, ServiceResponse value) {
                builder.addService(value);
            }
        }, new BiConsumer<ListServiceResponse.Builder, ListServiceResponse.Builder>(){

            @Override
            public void accept(ListServiceResponse.Builder b1, ListServiceResponse.Builder b2) {
                b1.addAllService((Iterable)b2.getServiceList());
            }
        }).build();
        return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setListServicesResponse(response).build();
    }

    private ServerReflectionResponse getFileByName(ServerReflectionRequest request) {
        String name = request.getFileByFilename();
        Descriptors.FileDescriptor fd = this.index.getFileDescriptorByName(name);
        if (fd != null) {
            return this.getServerReflectionResponse(request, fd);
        }
        return this.getErrorResponse(request, Status.Code.NOT_FOUND, "File not found (" + name + ")");
    }

    private ServerReflectionResponse getFileContainingSymbol(ServerReflectionRequest request) {
        String symbol = request.getFileContainingSymbol();
        Descriptors.FileDescriptor fd = this.index.getFileDescriptorBySymbol(symbol);
        if (fd != null) {
            return this.getServerReflectionResponse(request, fd);
        }
        return this.getErrorResponse(request, Status.Code.NOT_FOUND, "Symbol not found (" + symbol + ")");
    }

    private ServerReflectionResponse getFileByExtension(ServerReflectionRequest request) {
        int extension;
        ExtensionRequest extensionRequest = request.getFileContainingExtension();
        String type = extensionRequest.getContainingType();
        Descriptors.FileDescriptor fd = this.index.getFileDescriptorByExtensionAndNumber(type, extension = extensionRequest.getExtensionNumber());
        if (fd != null) {
            return this.getServerReflectionResponse(request, fd);
        }
        return this.getErrorResponse(request, Status.Code.NOT_FOUND, "Extension not found (" + type + ", " + extension + ")");
    }

    private ServerReflectionResponse getAllExtensions(ServerReflectionRequest request) {
        String type = request.getAllExtensionNumbersOfType();
        Set<Integer> extensions = this.index.getExtensionNumbersOfType(type);
        if (extensions != null) {
            ExtensionNumberResponse.Builder builder = ExtensionNumberResponse.newBuilder().setBaseTypeName(type).addAllExtensionNumber(extensions);
            return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setAllExtensionNumbersResponse(builder).build();
        }
        return this.getErrorResponse(request, Status.Code.NOT_FOUND, "Type not found.");
    }

    private ServerReflectionResponse getServerReflectionResponse(ServerReflectionRequest request, Descriptors.FileDescriptor fd) {
        FileDescriptorResponse.Builder fdRBuilder = FileDescriptorResponse.newBuilder();
        HashSet<String> seenFiles = new HashSet<String>();
        ArrayDeque<Descriptors.FileDescriptor> frontier = new ArrayDeque<Descriptors.FileDescriptor>();
        seenFiles.add(fd.getName());
        frontier.add(fd);
        while (!frontier.isEmpty()) {
            Descriptors.FileDescriptor nextFd = (Descriptors.FileDescriptor)frontier.remove();
            fdRBuilder.addFileDescriptorProto(nextFd.toProto().toByteString());
            for (Descriptors.FileDescriptor dependencyFd : nextFd.getDependencies()) {
                if (seenFiles.contains(dependencyFd.getName())) continue;
                seenFiles.add(dependencyFd.getName());
                frontier.add(dependencyFd);
            }
        }
        return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setFileDescriptorResponse(fdRBuilder).build();
    }

    private ServerReflectionResponse getErrorResponse(ServerReflectionRequest request, Status.Code code, String message) {
        return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setErrorResponse(ErrorResponse.newBuilder().setErrorCode(code.value()).setErrorMessage(message)).build();
    }
}

