/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.devmode;

import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import io.quarkus.grpc.runtime.devmode.CollectStreams;
import io.quarkus.grpc.stubs.ServerCalls;
import io.quarkus.grpc.stubs.StreamCollector;
import javax.annotation.Priority;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@CollectStreams
@Priority(value=1)
@Interceptor
public class StreamCollectorInterceptor {
    private final StreamCollector streamCollector = ServerCalls.getStreamCollector();

    @AroundInvoke
    Object collect(InvocationContext context) throws Exception {
        Object[] params = context.getParameters();
        int streamIndex = 0;
        StreamObserver stream = null;
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param == null || !StreamObserver.class.isAssignableFrom(param.getClass())) continue;
            stream = (StreamObserver)param;
            streamIndex = i;
            break;
        }
        if (stream == null) {
            return context.proceed();
        }
        this.streamCollector.add(stream);
        Object[] newParams = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            newParams[i] = i == streamIndex ? this.wrap((StreamObserver<Object>)stream) : params[i];
        }
        context.setParameters(newParams);
        return context.proceed();
    }

    private StreamObserver<Object> wrap(StreamObserver<Object> stream) {
        if (stream instanceof ServerCallStreamObserver) {
            return new ServerCallStreamObserverWrapper((ServerCallStreamObserver)stream);
        }
        return new StreamObserverWrapper<Object>(stream);
    }

    private final class ServerCallStreamObserverWrapper<T>
    extends ServerCallStreamObserver<T> {
        private final ServerCallStreamObserver<T> delegate;

        public ServerCallStreamObserverWrapper(ServerCallStreamObserver<T> delegate) {
            this.delegate = delegate;
        }

        public void onNext(T value) {
            this.delegate.onNext(value);
        }

        public void onError(Throwable t) {
            this.delegate.onError(t);
            StreamCollectorInterceptor.this.streamCollector.remove(this.delegate);
        }

        public void onCompleted() {
            this.delegate.onCompleted();
            StreamCollectorInterceptor.this.streamCollector.remove(this.delegate);
        }

        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        public void setOnCancelHandler(Runnable runnable) {
            this.delegate.setOnCancelHandler(runnable);
        }

        public void setCompression(String s) {
            this.delegate.setCompression(s);
        }

        public void disableAutoRequest() {
            this.delegate.disableAutoRequest();
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }

        public void setOnReadyHandler(Runnable runnable) {
            this.delegate.setOnReadyHandler(runnable);
        }

        public void request(int i) {
            this.delegate.request(i);
        }

        public void setMessageCompression(boolean b) {
            this.delegate.setMessageCompression(b);
        }

        public void setOnCloseHandler(Runnable onCloseHandler) {
            this.delegate.setOnCloseHandler(onCloseHandler);
        }

        public void disableAutoInboundFlowControl() {
            this.delegate.disableAutoInboundFlowControl();
        }
    }

    private final class StreamObserverWrapper<T>
    implements StreamObserver<T> {
        private final StreamObserver<T> delegate;

        public StreamObserverWrapper(StreamObserver<T> delegate) {
            this.delegate = delegate;
        }

        public void onNext(T value) {
            this.delegate.onNext(value);
        }

        public void onError(Throwable t) {
            this.delegate.onError(t);
            StreamCollectorInterceptor.this.streamCollector.remove(this.delegate);
        }

        public void onCompleted() {
            this.delegate.onCompleted();
            StreamCollectorInterceptor.this.streamCollector.remove(this.delegate);
        }
    }
}

