/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.stork;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Context;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.quarkus.grpc.runtime.stork.AbstractStorkMeasuringCall;
import io.quarkus.grpc.runtime.stork.StorkMeasuringCallListener;
import io.smallrye.stork.api.ServiceInstance;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.Prioritized;
import java.util.concurrent.atomic.AtomicReference;

@ApplicationScoped
public class StorkMeasuringGrpcInterceptor
implements ClientInterceptor,
Prioritized {
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        return new StorkMeasuringCall(next.newCall(method, callOptions), method.getType());
    }

    public int getPriority() {
        return 2147483547;
    }

    private static class StorkMeasuringCall<ReqT, RespT>
    extends AbstractStorkMeasuringCall<ReqT, RespT> {
        ServiceInstance serviceInstance;

        protected StorkMeasuringCall(ClientCall<ReqT, RespT> delegate, MethodDescriptor.MethodType type) {
            super(delegate, type == MethodDescriptor.MethodType.UNARY);
        }

        @Override
        protected ServiceInstance serviceInstance() {
            return this.serviceInstance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(ClientCall.Listener<RespT> responseListener, Metadata metadata) {
            Context context = Context.current().withValues(STORK_SERVICE_INSTANCE, new AtomicReference(), STORK_MEASURE_TIME, (Object)this.recordTime);
            Context oldContext = context.attach();
            try {
                super.start(new StorkMeasuringCallListener<RespT>(responseListener, this), metadata);
                this.serviceInstance = (ServiceInstance)((AtomicReference)STORK_SERVICE_INSTANCE.get()).get();
            }
            finally {
                context.detach(oldContext);
            }
        }
    }
}

