/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime;

import java.util.HashSet;
import java.util.Set;

public final class ClientInterceptorStorage {
    private final Set<Class<?>> perClientInterceptors;
    private final Set<Class<?>> globalInterceptors;

    public ClientInterceptorStorage(Set<Class<?>> perClientInterceptors, Set<Class<?>> globalInterceptors) {
        this.perClientInterceptors = Set.copyOf(perClientInterceptors);
        this.globalInterceptors = Set.copyOf(globalInterceptors);
    }

    public Set<Class<?>> getPerClientInterceptors(Set<String> interceptorClasses) {
        HashSet ret = new HashSet();
        for (Class<?> interceptor : this.perClientInterceptors) {
            if (!interceptorClasses.contains(interceptor.getName())) continue;
            ret.add(interceptor);
        }
        return ret;
    }

    public Class<?> getPerClientInterceptor(String interceptorClass) {
        for (Class<?> interceptor : this.perClientInterceptors) {
            if (!interceptor.getName().equals(interceptorClass)) continue;
            return interceptor;
        }
        return null;
    }

    public Set<Class<?>> getGlobalInterceptors() {
        return this.globalInterceptors;
    }
}

