/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hal;

import io.quarkus.hal.HalCollectionWrapper;
import io.quarkus.hal.HalEntityWrapper;
import io.quarkus.hal.HalLink;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public abstract class HalService {
    private static final String SELF_REF = "self";

    public <T> HalCollectionWrapper<T> toHalCollectionWrapper(Collection<T> collection, String collectionName, Class<?> entityClass) {
        ArrayList items = new ArrayList();
        for (T entity : collection) {
            items.add(this.toHalWrapper(entity));
        }
        Map<String, HalLink> classLinks = Collections.emptyMap();
        if (entityClass != null) {
            classLinks = this.getClassLinks(entityClass);
        }
        return new HalCollectionWrapper(items, collectionName, classLinks);
    }

    public <T> HalEntityWrapper<T> toHalWrapper(T entity) {
        return new HalEntityWrapper<T>(entity, this.getInstanceLinks(entity));
    }

    public String getSelfLink(Object entity) {
        HalLink halLink = this.getInstanceLinks(entity).get(SELF_REF);
        if (halLink != null) {
            return halLink.getHref();
        }
        return null;
    }

    protected abstract Map<String, HalLink> getClassLinks(Class<?> var1);

    protected abstract Map<String, HalLink> getInstanceLinks(Object var1);
}

