/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.deployment.QuarkusClassVisitor;
import io.quarkus.deployment.QuarkusClassWriter;
import io.quarkus.hibernate.orm.deployment.integration.QuarkusClassFileLocator;
import io.quarkus.hibernate.orm.deployment.integration.QuarkusEnhancementContext;
import java.util.function.BiFunction;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.dynamic.ClassFileLocator;
import org.hibernate.bytecode.enhance.internal.bytebuddy.CoreTypePool;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerClassLocator;
import org.hibernate.bytecode.enhance.internal.bytebuddy.ModelTypePool;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.internal.bytebuddy.BytecodeProviderImpl;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public final class HibernateEntityEnhancer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private static final BytecodeProviderImpl PROVIDER = new BytecodeProviderImpl(ClassFileVersion.JAVA_V17);
    static final CoreTypePool CORE_TYPE_POOL = new CoreTypePool(new String[]{"java.", "jakarta.", "org.hibernate.bytecode.enhance.spi.", "org.hibernate.engine.spi.", "org.hibernate.annotations.", "io.quarkus.hibernate.reactive.panache.", "io.quarkus.hibernate.orm.panache.", "org.hibernate.search.mapper.pojo.mapping.definition.annotation."});
    private final EnhancerHolder enhancerHolder = new EnhancerHolder();

    @Override
    public ClassVisitor apply(String className, ClassVisitor outputClassVisitor) {
        return new HibernateEnhancingClassVisitor(className, outputClassVisitor, this.enhancerHolder);
    }

    public byte[] enhance(String className, byte[] bytes) {
        return this.enhancerHolder.getEnhancer().enhance(className, bytes);
    }

    private static class EnhancerHolder {
        private volatile Enhancer actualEnhancer;

        private EnhancerHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Enhancer getEnhancer() {
            if (this.actualEnhancer == null) {
                EnhancerHolder enhancerHolder = this;
                synchronized (enhancerHolder) {
                    if (this.actualEnhancer == null) {
                        EnhancerClassLocator enhancerClassLocator = ModelTypePool.buildModelTypePool((ClassFileLocator)QuarkusClassFileLocator.INSTANCE, (CoreTypePool)CORE_TYPE_POOL);
                        this.actualEnhancer = PROVIDER.getEnhancer((EnhancementContext)QuarkusEnhancementContext.INSTANCE, enhancerClassLocator);
                    }
                }
            }
            return this.actualEnhancer;
        }
    }

    private static class HibernateEnhancingClassVisitor
    extends QuarkusClassVisitor {
        private final String className;
        private final ClassVisitor outputClassVisitor;
        private final EnhancerHolder enhancerHolder;

        public HibernateEnhancingClassVisitor(String className, ClassVisitor outputClassVisitor, EnhancerHolder enhancerHolder) {
            super(589824, (ClassVisitor)new QuarkusClassWriter(3));
            this.className = className;
            this.outputClassVisitor = outputClassVisitor;
            this.enhancerHolder = enhancerHolder;
        }

        public void visitEnd() {
            super.visitEnd();
            ClassWriter writer = (ClassWriter)this.cv;
            byte[] inputBytes = writer.toByteArray();
            byte[] transformedBytes = this.hibernateEnhancement(this.className, inputBytes);
            ClassReader cr = new ClassReader(transformedBytes);
            cr.accept(this.outputClassVisitor, super.getOriginalClassReaderOptions());
        }

        private byte[] hibernateEnhancement(String className, byte[] originalBytes) {
            byte[] enhanced = this.enhancerHolder.getEnhancer().enhance(className, originalBytes);
            return enhanced == null ? originalBytes : enhanced;
        }
    }
}

