/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.deployment;

import io.quarkus.hibernate.orm.deployment.HibernateOrmConfigPersistenceUnit;
import io.quarkus.hibernate.orm.runtime.config.DatabaseOrmCompatibilityVersion;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.annotations.ConvertWith;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;

@ConfigRoot
public class HibernateOrmConfig {
    @ConfigItem(defaultValue="true")
    public boolean enabled;
    @ConfigItem
    public HibernateOrmConfigDatabase database;
    @ConfigItem(name="<<parent>>")
    public HibernateOrmConfigPersistenceUnit defaultPersistenceUnit;
    @ConfigItem(name="<<parent>>")
    public Map<String, HibernateOrmConfigPersistenceUnit> persistenceUnits;
    @ConfigItem
    public HibernateOrmConfigPersistenceXml persistenceXml;
    @ConfigItem
    public HibernateOrmConfigLog log;
    @ConfigItem
    public Optional<Boolean> statistics;
    @ConfigItem
    public Optional<Boolean> logSessionMetrics;
    @ConfigItem
    public HibernateOrmConfigMetric metrics;

    public boolean isAnyNonPersistenceXmlPropertySet() {
        return this.defaultPersistenceUnit.isAnyPropertySet() || !this.persistenceUnits.isEmpty() || this.log.isAnyPropertySet() || this.statistics.isPresent() || this.logSessionMetrics.isPresent() || this.metrics.isAnyPropertySet();
    }

    public Map<String, HibernateOrmConfigPersistenceUnit> getAllPersistenceUnitConfigsAsMap() {
        TreeMap<String, HibernateOrmConfigPersistenceUnit> map = new TreeMap<String, HibernateOrmConfigPersistenceUnit>();
        if (this.defaultPersistenceUnit != null) {
            map.put("<default>", this.defaultPersistenceUnit);
        }
        map.putAll(this.persistenceUnits);
        return map;
    }

    @ConfigGroup
    public static class HibernateOrmConfigLog {
        @ConfigItem
        @Deprecated
        public boolean bindParam;
        @ConfigItem
        public boolean bindParameters;

        public boolean isAnyPropertySet() {
            return this.bindParam || this.bindParameters;
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigMetric {
        @ConfigItem
        public boolean enabled;

        public boolean isAnyPropertySet() {
            return this.enabled;
        }
    }

    @ConfigGroup
    public static class HibernateOrmConfigDatabase {
        @ConfigItem(name="orm-compatibility.version", defaultValue="latest")
        @ConvertWith(value=DatabaseOrmCompatibilityVersion.Converter.class)
        public DatabaseOrmCompatibilityVersion ormCompatibilityVersion;
    }

    @ConfigGroup
    public static class HibernateOrmConfigPersistenceXml {
        @ConfigItem
        public boolean ignore;
    }
}

