/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.tenant;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.DataSource;
import io.quarkus.agroal.runtime.AgroalDataSourceUtil;
import io.quarkus.arc.Arc;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusConnectionProvider;
import io.quarkus.hibernate.orm.runtime.migration.MultiTenancyStrategy;
import io.quarkus.hibernate.orm.runtime.tenant.TenantConnectionResolver;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Optional;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.jboss.logging.Logger;

public class DataSourceTenantConnectionResolver
implements TenantConnectionResolver {
    private static final Logger LOG = Logger.getLogger(DataSourceTenantConnectionResolver.class);
    private String persistenceUnitName;
    private Optional<String> dataSourceName;
    private MultiTenancyStrategy multiTenancyStrategy;

    public DataSourceTenantConnectionResolver() {
    }

    public DataSourceTenantConnectionResolver(String persistenceUnitName, Optional<String> dataSourceName, MultiTenancyStrategy multiTenancyStrategy) {
        this.persistenceUnitName = persistenceUnitName;
        this.dataSourceName = dataSourceName;
        this.multiTenancyStrategy = multiTenancyStrategy;
    }

    @Override
    public ConnectionProvider resolve(String tenantId) {
        LOG.debugv("resolve((persistenceUnitName={0}, tenantIdentifier={1})", (Object)this.persistenceUnitName, (Object)tenantId);
        LOG.debugv("multitenancy strategy: {0}", (Object)this.multiTenancyStrategy);
        AgroalDataSource dataSource = DataSourceTenantConnectionResolver.tenantDataSource(this.dataSourceName, tenantId, this.multiTenancyStrategy);
        if (dataSource == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "No instance of datasource found for persistence unit '%1$s' and tenant '%2$s'", this.persistenceUnitName, tenantId));
        }
        return switch (this.multiTenancyStrategy) {
            case MultiTenancyStrategy.DATABASE -> new QuarkusConnectionProvider(dataSource);
            case MultiTenancyStrategy.SCHEMA -> new SchemaTenantConnectionProvider(tenantId, dataSource);
            default -> throw new IllegalStateException("Unexpected multitenancy strategy: " + this.multiTenancyStrategy);
        };
    }

    private static AgroalDataSource tenantDataSource(Optional<String> dataSourceName, String tenantId, MultiTenancyStrategy strategy) {
        return switch (strategy) {
            case MultiTenancyStrategy.DATABASE -> (AgroalDataSource)Arc.container().instance(AgroalDataSource.class, new Annotation[]{new DataSource.DataSourceLiteral(tenantId)}).get();
            case MultiTenancyStrategy.SCHEMA -> DataSourceTenantConnectionResolver.getDataSource(dataSourceName.get());
            default -> throw new IllegalStateException("Unexpected multitenancy strategy: " + strategy);
        };
    }

    private static AgroalDataSource getDataSource(String dataSourceName) {
        return (AgroalDataSource)Arc.container().instance(AgroalDataSource.class, new Annotation[]{AgroalDataSourceUtil.qualifier((String)dataSourceName)}).get();
    }

    private static class SchemaTenantConnectionProvider
    extends QuarkusConnectionProvider {
        private final String tenantId;

        public SchemaTenantConnectionProvider(String tenantId, AgroalDataSource dataSource) {
            super(dataSource);
            this.tenantId = tenantId;
        }

        @Override
        public Connection getConnection() throws SQLException {
            Connection conn = super.getConnection();
            conn.setSchema(this.tenantId);
            LOG.debugv("Set tenant {0} for connection: {1}", (Object)this.tenantId, (Object)conn);
            return conn;
        }
    }
}

