/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.boot;

import io.quarkus.arc.InjectableInstance;
import io.quarkus.hibernate.orm.JsonFormat;
import io.quarkus.hibernate.orm.XmlFormat;
import io.quarkus.hibernate.orm.runtime.PersistenceUnitUtil;
import io.quarkus.hibernate.orm.runtime.RuntimeSettings;
import io.quarkus.hibernate.orm.runtime.migration.MultiTenancyStrategy;
import io.quarkus.hibernate.orm.runtime.observers.QuarkusSessionFactoryObserverForDbVersionCheck;
import io.quarkus.hibernate.orm.runtime.observers.SessionFactoryObserverForNamedQueryValidation;
import io.quarkus.hibernate.orm.runtime.observers.SessionFactoryObserverForSchemaExport;
import io.quarkus.hibernate.orm.runtime.recording.PrevalidatedQuarkusMetadata;
import io.quarkus.hibernate.orm.runtime.tenant.HibernateCurrentTenantIdentifierResolver;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.security.NoSuchAlgorithmException;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.internal.SessionFactoryOptionsBuilder;
import org.hibernate.boot.model.process.spi.ManagedResources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.bytecode.internal.SessionFactoryObserverForBytecodeEnhancer;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.spi.CommandAcceptanceException;
import org.hibernate.tool.schema.spi.DelayedDropRegistry;
import org.hibernate.tool.schema.spi.DelayedDropRegistryNotAvailableImpl;
import org.hibernate.tool.schema.spi.SchemaManagementToolCoordinator;
import org.hibernate.type.format.FormatMapper;

public class FastBootEntityManagerFactoryBuilder
implements EntityManagerFactoryBuilder {
    protected final PrevalidatedQuarkusMetadata metadata;
    protected final String persistenceUnitName;
    protected final StandardServiceRegistry standardServiceRegistry;
    private final RuntimeSettings runtimeSettings;
    private final Object validatorFactory;
    private final Object cdiBeanManager;
    protected final MultiTenancyStrategy multiTenancyStrategy;

    public FastBootEntityManagerFactoryBuilder(PrevalidatedQuarkusMetadata metadata, String persistenceUnitName, StandardServiceRegistry standardServiceRegistry, RuntimeSettings runtimeSettings, Object validatorFactory, Object cdiBeanManager, MultiTenancyStrategy multiTenancyStrategy) {
        this.metadata = metadata;
        this.persistenceUnitName = persistenceUnitName;
        this.standardServiceRegistry = standardServiceRegistry;
        this.runtimeSettings = runtimeSettings;
        this.validatorFactory = validatorFactory;
        this.cdiBeanManager = cdiBeanManager;
        this.multiTenancyStrategy = multiTenancyStrategy;
    }

    public EntityManagerFactoryBuilder withValidatorFactory(Object validatorFactory) {
        return null;
    }

    public EntityManagerFactoryBuilder withDataSource(DataSource dataSource) {
        return null;
    }

    public EntityManagerFactory build() {
        try {
            SessionFactoryOptionsBuilder optionsBuilder = this.metadata.buildSessionFactoryOptionsBuilder();
            this.populate(this.persistenceUnitName, optionsBuilder, this.standardServiceRegistry);
            return new SessionFactoryImpl((MetadataImplementor)this.metadata, optionsBuilder.buildOptions(), this.metadata.getTypeConfiguration().getMetadataBuildingContext().getBootstrapContext());
        }
        catch (Exception e) {
            throw this.persistenceException("Unable to build Hibernate SessionFactory", e);
        }
    }

    public void cancel() {
    }

    public void generateSchema() {
        try {
            SchemaManagementToolCoordinator.process((Metadata)this.metadata, (ServiceRegistry)this.standardServiceRegistry, this.runtimeSettings.getSettings(), (DelayedDropRegistry)DelayedDropRegistryNotAvailableImpl.INSTANCE);
        }
        catch (Exception e) {
            throw this.persistenceException("Error performing schema management", e);
        }
        this.cancel();
    }

    protected PersistenceException persistenceException(String message, Exception cause) {
        for (Throwable t = cause; t != null; t = t.getCause()) {
            if (t instanceof NoSuchAlgorithmException) {
                message = (String)message + "Unable to enable SSL support. You might be in the case where you used the `quarkus.ssl.native=false` configuration and SSL was not disabled automatically for your driver.";
                break;
            }
            if (!(t instanceof CommandAcceptanceException)) continue;
            message = "Invalid import file. Make sure your statements are valid and properly separated by a semi-colon.";
            break;
        }
        return new PersistenceException(this.getExceptionHeader() + (String)message, (Throwable)cause);
    }

    private String getExceptionHeader() {
        return "[PersistenceUnit: " + this.persistenceUnitName + "] ";
    }

    protected void populate(String persistenceUnitName, SessionFactoryOptionsBuilder options, StandardServiceRegistry ssr) {
        InjectableInstance<FormatMapper> xmlFormatMapper;
        InjectableInstance<FormatMapper> jsonFormatMapper;
        InjectableInstance<StatementInspector> statementInspectorInstance;
        InjectableInstance<Interceptor> interceptorInstance;
        Object legacyObserver;
        boolean allowRefreshDetachedEntity;
        boolean jtaTransactionAccessEnabled = this.runtimeSettings.getBoolean("hibernate.jta.allowTransactionAccess");
        if (!jtaTransactionAccessEnabled) {
            options.disableJtaTransactionAccess();
        }
        if (!(allowRefreshDetachedEntity = this.runtimeSettings.getBoolean("hibernate.allow_refresh_detached_entity"))) {
            options.disableRefreshDetachedEntity();
        }
        if ((legacyObserver = this.runtimeSettings.get("hibernate.ejb.session_factory_observer")) != null) {
            throw new HibernateException("Legacy setting being used: 'hibernate.ejb.session_factory_observer' was replaced by 'hibernate.session_factory_observer'. Please update your configuration.");
        }
        Object sessionFactoryObserverSetting = this.runtimeSettings.get("hibernate.session_factory_observer");
        if (sessionFactoryObserverSetting != null) {
            StrategySelector strategySelector = (StrategySelector)ssr.getService(StrategySelector.class);
            SessionFactoryObserver suppliedSessionFactoryObserver = (SessionFactoryObserver)strategySelector.resolveStrategy(SessionFactoryObserver.class, sessionFactoryObserverSetting);
            options.addSessionFactoryObservers(new SessionFactoryObserver[]{suppliedSessionFactoryObserver});
        }
        options.addSessionFactoryObservers(new SessionFactoryObserver[]{new ServiceRegistryCloser()});
        options.addSessionFactoryObservers(new SessionFactoryObserver[]{new SessionFactoryObserverForNamedQueryValidation(this.metadata)});
        options.addSessionFactoryObservers(new SessionFactoryObserver[]{new SessionFactoryObserverForSchemaExport(this.metadata)});
        options.addSessionFactoryObservers(new SessionFactoryObserver[]{new QuarkusSessionFactoryObserverForDbVersionCheck()});
        options.applyEntityNotFoundDelegate((EntityNotFoundDelegate)new JpaEntityNotFoundDelegate());
        options.enableCollectionInDefaultFetchGroup(true);
        if (this.validatorFactory != null) {
            options.applyValidatorFactory(this.validatorFactory);
        }
        if (this.cdiBeanManager != null) {
            options.applyBeanManager(this.cdiBeanManager);
        }
        BytecodeProvider bytecodeProvider = (BytecodeProvider)ssr.getService(BytecodeProvider.class);
        options.addSessionFactoryObservers(new SessionFactoryObserver[]{new SessionFactoryObserverForBytecodeEnhancer(bytecodeProvider)});
        if (options.isMultiTenancyEnabled() || this.multiTenancyStrategy != null && this.multiTenancyStrategy != MultiTenancyStrategy.NONE) {
            options.applyCurrentTenantIdentifierResolver((CurrentTenantIdentifierResolver)new HibernateCurrentTenantIdentifierResolver(persistenceUnitName));
        }
        if (!(interceptorInstance = PersistenceUnitUtil.singleExtensionInstanceForPersistenceUnit(Interceptor.class, persistenceUnitName, new Annotation[0])).isUnsatisfied()) {
            options.applyStatelessInterceptorSupplier(() -> interceptorInstance.get());
        }
        if (!(statementInspectorInstance = PersistenceUnitUtil.singleExtensionInstanceForPersistenceUnit(StatementInspector.class, persistenceUnitName, new Annotation[0])).isUnsatisfied()) {
            options.applyStatementInspector((StatementInspector)statementInspectorInstance.get());
        }
        if (!(jsonFormatMapper = PersistenceUnitUtil.singleExtensionInstanceForPersistenceUnit(FormatMapper.class, persistenceUnitName, JsonFormat.Literal.INSTANCE)).isUnsatisfied()) {
            options.applyJsonFormatMapper((FormatMapper)jsonFormatMapper.get());
        }
        if (!(xmlFormatMapper = PersistenceUnitUtil.singleExtensionInstanceForPersistenceUnit(FormatMapper.class, persistenceUnitName, XmlFormat.Literal.INSTANCE)).isUnsatisfied()) {
            options.applyXmlFormatMapper((FormatMapper)xmlFormatMapper.get());
        }
    }

    public ManagedResources getManagedResources() {
        throw new IllegalStateException("This method is not available at runtime in Quarkus");
    }

    public MetadataImplementor metadata() {
        return this.metadata;
    }

    private static class ServiceRegistryCloser
    implements SessionFactoryObserver {
        private ServiceRegistryCloser() {
        }

        public void sessionFactoryCreated(SessionFactory sessionFactory) {
        }

        public void sessionFactoryClosed(SessionFactory sessionFactory) {
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)sessionFactory;
            sfi.getServiceRegistry().destroy();
            ServiceRegistry basicRegistry = sfi.getServiceRegistry().getParentServiceRegistry();
            ((ServiceRegistryImplementor)basicRegistry).destroy();
        }
    }

    private static class JpaEntityNotFoundDelegate
    implements EntityNotFoundDelegate,
    Serializable {
        private JpaEntityNotFoundDelegate() {
        }

        public void handleEntityNotFound(String entityName, Object id) {
            throw new EntityNotFoundException("Unable to find " + entityName + " with id " + id);
        }
    }
}

