/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.reactive.panache.common.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.reactive.common.spi.Implementor;
import org.hibernate.reactive.context.Context;
import org.hibernate.reactive.context.impl.BaseKey;
import org.hibernate.reactive.mutiny.Mutiny;

public final class SessionOperations {
    private static final String ERROR_MSG = "Hibernate Reactive Panache requires a safe (isolated) Vert.x sub-context, but the current context hasn't been flagged as such.";
    private static final LazyValue<Mutiny.SessionFactory> SESSION_FACTORY = new LazyValue((Supplier)new Supplier<Mutiny.SessionFactory>(){

        @Override
        public Mutiny.SessionFactory get() {
            Mutiny.SessionFactory sessionFactory = (Mutiny.SessionFactory)Arc.container().instance(Mutiny.SessionFactory.class, new Annotation[0]).get();
            if (sessionFactory == null) {
                throw new IllegalStateException("Mutiny.SessionFactory bean not found");
            }
            return sessionFactory;
        }
    });
    private static final LazyValue<Context.Key<Mutiny.Session>> SESSION_KEY = new LazyValue((Supplier)new Supplier<Context.Key<Mutiny.Session>>(){

        @Override
        public Context.Key<Mutiny.Session> get() {
            return new BaseKey(Mutiny.Session.class, ((Implementor)SESSION_FACTORY.get()).getUuid());
        }
    });
    private static final String SESSION_ON_DEMAND_KEY = "hibernate.reactive.panache.sessionOnDemand";

    static <T> Uni<T> withSessionOnDemand(Supplier<Uni<T>> work) {
        Context context = SessionOperations.vertxContext();
        if (context.getLocal((Object)SESSION_ON_DEMAND_KEY) != null) {
            return work.get();
        }
        context.putLocal((Object)SESSION_ON_DEMAND_KEY, (Object)true);
        return work.get().eventually(() -> {
            context.removeLocal((Object)SESSION_ON_DEMAND_KEY);
            return SessionOperations.closeSession();
        });
    }

    public static <T> Uni<T> withTransaction(Supplier<Uni<T>> work) {
        return SessionOperations.withSession(s -> s.withTransaction(arg_0 -> SessionOperations.lambda$withTransaction$1((Supplier)work, arg_0)));
    }

    public static <T> Uni<T> withTransaction(Function<Mutiny.Transaction, Uni<T>> work) {
        return SessionOperations.withSession(s -> s.withTransaction((T t) -> (Uni)work.apply((Mutiny.Transaction)t)));
    }

    public static <T> Uni<T> withSession(Function<Mutiny.Session, Uni<T>> work) {
        Context.Key<Mutiny.Session> key;
        Context context = SessionOperations.vertxContext();
        Mutiny.Session current = (Mutiny.Session)context.getLocal(key = SessionOperations.getSessionKey());
        if (current != null && current.isOpen()) {
            return work.apply(current);
        }
        return SessionOperations.getSessionFactory().openSession().invoke(s -> context.putLocal((Object)key, s)).chain(s -> (Uni)work.apply((Mutiny.Session)s)).eventually(() -> SessionOperations.closeSession());
    }

    public static Uni<Mutiny.Session> getSession() {
        Context.Key<Mutiny.Session> key;
        Context context = SessionOperations.vertxContext();
        Mutiny.Session current = (Mutiny.Session)context.getLocal(key = SessionOperations.getSessionKey());
        if (current != null && current.isOpen()) {
            return Uni.createFrom().item((Object)current);
        }
        if (context.getLocal((Object)SESSION_ON_DEMAND_KEY) != null) {
            return SessionOperations.getSessionFactory().openSession().invoke(s -> context.putLocal((Object)key, s));
        }
        throw new IllegalStateException("No current Mutiny.Session found\n\t- no reactive session was found in the context and the context was not marked to open a new session lazily\n\t- you might need to annotate the business method with @WithSession");
    }

    public static Mutiny.Session getCurrentSession() {
        Context context = SessionOperations.vertxContext();
        Mutiny.Session current = (Mutiny.Session)context.getLocal(SessionOperations.getSessionKey());
        if (current != null && current.isOpen()) {
            return current;
        }
        return null;
    }

    private static Context vertxContext() {
        Context context = Vertx.currentContext();
        if (context != null) {
            VertxContextSafetyToggle.validateContextIfExists((String)ERROR_MSG, (String)ERROR_MSG);
            return context;
        }
        throw new IllegalStateException("No current Vertx context found");
    }

    static Uni<Void> closeSession() {
        Context.Key<Mutiny.Session> key;
        Context context = SessionOperations.vertxContext();
        Mutiny.Session current = (Mutiny.Session)context.getLocal(key = SessionOperations.getSessionKey());
        if (current != null && current.isOpen()) {
            return current.close().eventually(() -> context.removeLocal((Object)key));
        }
        return Uni.createFrom().voidItem();
    }

    static Context.Key<Mutiny.Session> getSessionKey() {
        return (Context.Key)SESSION_KEY.get();
    }

    static Mutiny.SessionFactory getSessionFactory() {
        return (Mutiny.SessionFactory)SESSION_FACTORY.get();
    }

    static void clear() {
        SESSION_FACTORY.clear();
        SESSION_KEY.clear();
    }

    private static /* synthetic */ Uni lambda$withTransaction$1(Supplier work, Mutiny.Transaction t) {
        return (Uni)work.get();
    }
}

