/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.standalone.elasticsearch.runtime;

import io.quarkus.hibernate.search.backend.elasticsearch.common.runtime.HibernateSearchBackendElasticsearchRuntimeConfig;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithUnnamedKey;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.mapper.pojo.standalone.schema.management.SchemaManagementStrategyName;

@ConfigMapping(prefix="quarkus.hibernate-search-standalone")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface HibernateSearchStandaloneRuntimeConfig {
    @ConfigDocDefault(value="'true' if Hibernate Search Standalone is enabled; 'false' otherwise")
    public Optional<Boolean> active();

    @ConfigDocSection
    @WithName(value="elasticsearch")
    @WithUnnamedKey
    @ConfigDocMapKey(value="backend-name")
    public Map<String, HibernateSearchBackendElasticsearchRuntimeConfig> backends();

    public SchemaManagementConfig schemaManagement();

    public IndexingConfig indexing();

    public static String extensionPropertyKey(String radical) {
        StringBuilder keyBuilder = new StringBuilder("quarkus.hibernate-search-standalone.");
        keyBuilder.append(radical);
        return keyBuilder.toString();
    }

    public static String mapperPropertyKey(String radical) {
        return "quarkus.hibernate-search-standalone." + radical;
    }

    public static List<String> mapperPropertyKeys(String radical) {
        return List.of(HibernateSearchStandaloneRuntimeConfig.mapperPropertyKey(radical));
    }

    public static String backendPropertyKey(String backendName, String indexName, String radical) {
        StringBuilder keyBuilder = new StringBuilder("quarkus.hibernate-search-standalone.");
        keyBuilder.append("elasticsearch.");
        if (backendName != null) {
            keyBuilder.append("\"").append(backendName).append("\".");
        }
        if (indexName != null) {
            keyBuilder.append("indexes.\"").append(indexName).append("\".");
        }
        keyBuilder.append(radical);
        return keyBuilder.toString();
    }

    public static List<String> defaultBackendPropertyKeys(String radical) {
        return HibernateSearchStandaloneRuntimeConfig.mapperPropertyKeys("elasticsearch." + radical);
    }

    @ConfigGroup
    public static interface SchemaManagementConfig {
        @WithDefault(value="create-or-validate")
        @ConfigDocDefault(value="drop-and-create-and-drop when using Dev Services; create-or-validate otherwise")
        public SchemaManagementStrategyName strategy();
    }

    @ConfigGroup
    public static interface IndexingPlanSynchronizationConfig {
        @ConfigDocDefault(value="write-sync")
        public Optional<String> strategy();
    }

    @ConfigGroup
    public static interface IndexingPlanConfig {
        public IndexingPlanSynchronizationConfig synchronization();
    }

    @ConfigGroup
    public static interface IndexingConfig {
        public IndexingPlanConfig plan();
    }
}

