/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.search.standalone.elasticsearch.runtime.management;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ManagedContext;
import io.quarkus.hibernate.search.standalone.elasticsearch.runtime.management.HibernateSearchStandaloneManagementPostRequestProcessor;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.util.Locale;

public class HibernateSearchStandaloneManagementHandler
implements Handler<RoutingContext> {
    public void handle(RoutingContext routingContext) {
        ManagedContext requestContext = Arc.container().requestContext();
        if (requestContext.isActive()) {
            this.doHandle(routingContext);
        } else {
            requestContext.activate();
            try {
                this.doHandle(routingContext);
            }
            finally {
                requestContext.terminate();
            }
        }
    }

    private void doHandle(RoutingContext ctx) {
        HttpServerRequest request = ctx.request();
        if (!HttpMethod.POST.equals((Object)request.method())) {
            this.errorResponse(ctx, 406, "Http method [" + request.method().name() + "] is not supported. Use [POST] instead.");
            return;
        }
        String contentType = request.getHeader(HttpHeaders.CONTENT_TYPE);
        if (contentType != null && !contentType.toLowerCase(Locale.ROOT).startsWith("application/json")) {
            this.errorResponse(ctx, 406, "Content type [" + contentType + " is not supported. Use [application/json] instead.");
            return;
        }
        new HibernateSearchStandaloneManagementPostRequestProcessor().process(ctx);
    }

    private void errorResponse(RoutingContext ctx, int code, String message) {
        ctx.response().setStatusCode(code).setStatusMessage(message).end();
    }
}

