/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.SyntheticCreationalContext;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.hibernate.validator.ValidatorFactoryCustomizer;
import io.quarkus.hibernate.validator.runtime.ArcConstraintValidatorFactoryImpl;
import io.quarkus.hibernate.validator.runtime.ArcProxyBeanMetaDataClassNormalizer;
import io.quarkus.hibernate.validator.runtime.HibernateBeanValidationConfigValidator;
import io.quarkus.hibernate.validator.runtime.HibernateValidatorBuildTimeConfig;
import io.quarkus.hibernate.validator.runtime.TraverseAllTraversableResolver;
import io.quarkus.hibernate.validator.runtime.clockprovider.RuntimeReinitializedDefaultClockProvider;
import io.quarkus.hibernate.validator.runtime.jaxrs.ResteasyConfigSupport;
import io.quarkus.hibernate.validator.runtime.locale.LocaleResolversWrapper;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.util.TypeLiteral;
import jakarta.validation.ClockProvider;
import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.ParameterNameProvider;
import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.valueextraction.ValueExtractor;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.validator.BaseHibernateValidatorConfiguration;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.PredefinedScopeHibernateValidator;
import org.hibernate.validator.PredefinedScopeHibernateValidatorConfiguration;
import org.hibernate.validator.metadata.BeanMetaDataClassNormalizer;
import org.hibernate.validator.spi.messageinterpolation.LocaleResolver;
import org.hibernate.validator.spi.nodenameprovider.PropertyNodeNameProvider;
import org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;

@Recorder
public class HibernateValidatorRecorder {
    private static final TypeLiteral<Instance<LocaleResolversWrapper>> INSTANCE_LOCAL_RESOLVER_WRAPPER_TYPE_LITERAL = new TypeLiteral<Instance<LocaleResolversWrapper>>(){};
    private static final TypeLiteral<Instance<ConstraintValidatorFactory>> INSTANCE_CONSTRAINT_VALIDATOR_FACTORY_TYPE_LITERAL = new TypeLiteral<Instance<ConstraintValidatorFactory>>(){};
    private static final TypeLiteral<Instance<MessageInterpolator>> INSTANCE_MESSAGE_INTERPOLATOR_TYPE_LITERAL = new TypeLiteral<Instance<MessageInterpolator>>(){};
    private static final TypeLiteral<Instance<TraversableResolver>> INSTANCE_TRAVERSABLE_RESOLVER_TYPE_LITERAL = new TypeLiteral<Instance<TraversableResolver>>(){};
    private static final TypeLiteral<Instance<ParameterNameProvider>> INSTANCE_PARAMETER_NAME_PROVIDER_TYPE_LITERAL = new TypeLiteral<Instance<ParameterNameProvider>>(){};
    private static final TypeLiteral<Instance<ClockProvider>> INSTANCE_CLOCK_PROVIDER_TYPE_LITERAL = new TypeLiteral<Instance<ClockProvider>>(){};
    private static final TypeLiteral<Instance<ScriptEvaluatorFactory>> INSTANCE_SCRIPT_EVALUATOR_TYPE_LITERAL = new TypeLiteral<Instance<ScriptEvaluatorFactory>>(){};
    private static final TypeLiteral<Instance<GetterPropertySelectionStrategy>> INSTANCE_GETTER_PROPERTY_SELECTION_STRATEGY_TYPE_LITERAL = new TypeLiteral<Instance<GetterPropertySelectionStrategy>>(){};
    private static final TypeLiteral<Instance<PropertyNodeNameProvider>> INSTANCE_PROPERTY_NODE_NAME_PROVIDER_TYPE_LITERAL = new TypeLiteral<Instance<PropertyNodeNameProvider>>(){};
    private static final TypeLiteral<Instance<ValidatorFactoryCustomizer>> INSTANCE_VALIDATOR_FACTORY_CUSTOMER_TYPE_LITERAL = new TypeLiteral<Instance<ValidatorFactoryCustomizer>>(){};

    public void shutdownConfigValidator(ShutdownContext shutdownContext) {
        shutdownContext.addShutdownTask(new Runnable(){

            @Override
            public void run() {
                ValidatorFactory validatorFactory = HibernateBeanValidationConfigValidator.ConfigValidatorHolder.getValidatorFactory();
                if (validatorFactory != null) {
                    validatorFactory.close();
                }
            }
        });
    }

    public Function<SyntheticCreationalContext<HibernateValidatorFactory>, HibernateValidatorFactory> hibernateValidatorFactory(final Set<Class<?>> classesToBeValidated, final Set<String> detectedBuiltinConstraints, final Set<Class<?>> valueExtractorClasses, final boolean hasXmlConfiguration, final Optional<BiPredicate<Object, String>> attributeLoadedPredicate, final LocalesBuildTimeConfig localesBuildTimeConfig, final HibernateValidatorBuildTimeConfig hibernateValidatorBuildTimeConfig) {
        return new Function<SyntheticCreationalContext<HibernateValidatorFactory>, HibernateValidatorFactory>(){

            @Override
            public HibernateValidatorFactory apply(SyntheticCreationalContext<HibernateValidatorFactory> context) {
                Instance configuredPropertyNodeNameProvider;
                Instance configuredGetterPropertySelectionStrategy;
                Instance configuredClockProvider;
                Instance configuredTraversableResolver;
                Instance configuredConstraintValidatorFactory;
                Instance configuredLocaleResolver;
                PredefinedScopeHibernateValidatorConfiguration configuration = (PredefinedScopeHibernateValidatorConfiguration)Validation.byProvider(PredefinedScopeHibernateValidator.class).configure();
                if (!hasXmlConfiguration) {
                    configuration.ignoreXmlConfiguration();
                }
                if ((configuredLocaleResolver = (Instance)context.getInjectedReference(INSTANCE_LOCAL_RESOLVER_WRAPPER_TYPE_LITERAL, new Annotation[]{NamedLiteral.of((String)"locale-resolver-wrapper")})).isResolvable()) {
                    LocaleResolver localeResolver = (LocaleResolver)configuredLocaleResolver.get();
                    configuration.localeResolver(localeResolver);
                }
                this.filterIncompleteClasses(classesToBeValidated);
                ((PredefinedScopeHibernateValidatorConfiguration)((PredefinedScopeHibernateValidatorConfiguration)configuration.builtinConstraints(detectedBuiltinConstraints).initializeBeanMetaData(classesToBeValidated).locales(localesBuildTimeConfig.locales().contains(Locale.ROOT) ? Set.of(Locale.getAvailableLocales()) : localesBuildTimeConfig.locales())).defaultLocale(localesBuildTimeConfig.defaultLocale().orElse(Locale.getDefault()))).beanMetaDataClassNormalizer((BeanMetaDataClassNormalizer)new ArcProxyBeanMetaDataClassNormalizer());
                if (hibernateValidatorBuildTimeConfig.expressionLanguage().constraintExpressionFeatureLevel().isPresent()) {
                    configuration.constraintExpressionLanguageFeatureLevel(hibernateValidatorBuildTimeConfig.expressionLanguage().constraintExpressionFeatureLevel().get());
                }
                if ((configuredConstraintValidatorFactory = (Instance)context.getInjectedReference(INSTANCE_CONSTRAINT_VALIDATOR_FACTORY_TYPE_LITERAL, new Annotation[0])).isResolvable()) {
                    configuration.constraintValidatorFactory((ConstraintValidatorFactory)configuredConstraintValidatorFactory.get());
                } else {
                    configuration.constraintValidatorFactory((ConstraintValidatorFactory)new ArcConstraintValidatorFactoryImpl());
                }
                Instance configuredMessageInterpolator = (Instance)context.getInjectedReference(INSTANCE_MESSAGE_INTERPOLATOR_TYPE_LITERAL, new Annotation[0]);
                if (configuredMessageInterpolator.isResolvable()) {
                    configuration.messageInterpolator((MessageInterpolator)configuredMessageInterpolator.get());
                }
                if ((configuredTraversableResolver = (Instance)context.getInjectedReference(INSTANCE_TRAVERSABLE_RESOLVER_TYPE_LITERAL, new Annotation[0])).isResolvable()) {
                    configuration.traversableResolver((TraversableResolver)configuredTraversableResolver.get());
                } else if (attributeLoadedPredicate.isPresent()) {
                    configuration.traversableResolver((TraversableResolver)new DelegatingTraversableResolver((BiPredicate)attributeLoadedPredicate.get()));
                } else {
                    configuration.traversableResolver((TraversableResolver)new TraverseAllTraversableResolver());
                }
                Instance configuredParameterNameProvider = (Instance)context.getInjectedReference(INSTANCE_PARAMETER_NAME_PROVIDER_TYPE_LITERAL, new Annotation[0]);
                if (configuredParameterNameProvider.isResolvable()) {
                    configuration.parameterNameProvider((ParameterNameProvider)configuredParameterNameProvider.get());
                }
                if ((configuredClockProvider = (Instance)context.getInjectedReference(INSTANCE_CLOCK_PROVIDER_TYPE_LITERAL, new Annotation[0])).isResolvable()) {
                    configuration.clockProvider((ClockProvider)configuredClockProvider.get());
                } else {
                    configuration.clockProvider((ClockProvider)RuntimeReinitializedDefaultClockProvider.INSTANCE);
                }
                configuration.failFast(hibernateValidatorBuildTimeConfig.failFast());
                configuration.allowOverridingMethodAlterParameterConstraint(hibernateValidatorBuildTimeConfig.methodValidation().allowOverridingParameterConstraints());
                configuration.allowParallelMethodsDefineParameterConstraints(hibernateValidatorBuildTimeConfig.methodValidation().allowParameterConstraintsOnParallelMethods());
                configuration.allowMultipleCascadedValidationOnReturnValues(hibernateValidatorBuildTimeConfig.methodValidation().allowMultipleCascadedValidationOnReturnValues());
                Instance configuredScriptEvaluatorFactory = (Instance)context.getInjectedReference(INSTANCE_SCRIPT_EVALUATOR_TYPE_LITERAL, new Annotation[0]);
                if (configuredScriptEvaluatorFactory.isResolvable()) {
                    configuration.scriptEvaluatorFactory((ScriptEvaluatorFactory)configuredScriptEvaluatorFactory.get());
                }
                if ((configuredGetterPropertySelectionStrategy = (Instance)context.getInjectedReference(INSTANCE_GETTER_PROPERTY_SELECTION_STRATEGY_TYPE_LITERAL, new Annotation[0])).isResolvable()) {
                    configuration.getterPropertySelectionStrategy((GetterPropertySelectionStrategy)configuredGetterPropertySelectionStrategy.get());
                }
                if ((configuredPropertyNodeNameProvider = (Instance)context.getInjectedReference(INSTANCE_PROPERTY_NODE_NAME_PROVIDER_TYPE_LITERAL, new Annotation[0])).isResolvable()) {
                    configuration.propertyNodeNameProvider((PropertyNodeNameProvider)configuredPropertyNodeNameProvider.get());
                }
                for (Object valueExtractor : HibernateValidatorRecorder.uniqueBeanInstances(valueExtractorClasses)) {
                    configuration.addValueExtractor((ValueExtractor)valueExtractor);
                }
                Instance validatorFactoryCustomizers = (Instance)context.getInjectedReference(INSTANCE_VALIDATOR_FACTORY_CUSTOMER_TYPE_LITERAL, new Annotation[0]);
                for (ValidatorFactoryCustomizer validatorFactoryCustomizer : validatorFactoryCustomizers) {
                    validatorFactoryCustomizer.customize((BaseHibernateValidatorConfiguration<?>)configuration);
                }
                ValidatorFactory validatorFactory = configuration.buildValidatorFactory();
                return (HibernateValidatorFactory)validatorFactory.unwrap(HibernateValidatorFactory.class);
            }

            private void filterIncompleteClasses(Set<Class<?>> classesToBeValidated2) {
                Iterator<Class<?>> iterator = classesToBeValidated2.iterator();
                while (iterator.hasNext()) {
                    Class<?> clazz = iterator.next();
                    try {
                        clazz.getCanonicalName();
                    }
                    catch (NoClassDefFoundError e) {
                        iterator.remove();
                    }
                }
            }
        };
    }

    public Function<SyntheticCreationalContext<Validator>, Validator> hibernateValidator(final String hibernateValidatorFactoryName) {
        return new Function<SyntheticCreationalContext<Validator>, Validator>(){

            @Override
            public Validator apply(SyntheticCreationalContext<Validator> context) {
                HibernateValidatorFactory hibernateValidatorFactory = (HibernateValidatorFactory)context.getInjectedReference(HibernateValidatorFactory.class, new Annotation[]{NamedLiteral.of((String)hibernateValidatorFactoryName)});
                return hibernateValidatorFactory.getValidator();
            }
        };
    }

    private static <T> Iterable<T> uniqueBeanInstances(Set<Class<?>> classes) {
        HashSet<String> beanIds = new HashSet<String>();
        for (Class<?> clazz : classes) {
            for (InstanceHandle handle : Arc.container().select(clazz, new Annotation[0]).handles()) {
                if (!handle.isAvailable()) continue;
                beanIds.add(handle.getBean().getIdentifier());
            }
        }
        ArrayList<Object> instances = new ArrayList<Object>();
        for (String beanId : beanIds) {
            ArcContainer arcContainer = Arc.container();
            instances.add(arcContainer.instance(arcContainer.bean(beanId)).get());
        }
        return instances;
    }

    public Supplier<ResteasyConfigSupport> resteasyConfigSupportSupplier(final boolean jsonDefault) {
        return new Supplier<ResteasyConfigSupport>(){

            @Override
            public ResteasyConfigSupport get() {
                return new ResteasyConfigSupport(jsonDefault);
            }
        };
    }

    public void hibernateValidatorFactoryInit(BeanContainer beanContainer) {
        HibernateValidatorFactory hibernateValidatorFactory = (HibernateValidatorFactory)beanContainer.beanInstance(HibernateValidatorFactory.class, new Annotation[0]);
    }

    static final class DelegatingTraversableResolver
    implements TraversableResolver {
        private final BiPredicate<Object, String> attributeLoadedPredicate;

        DelegatingTraversableResolver(BiPredicate<Object, String> attributeLoadedPredicate) {
            this.attributeLoadedPredicate = attributeLoadedPredicate;
        }

        public boolean isReachable(Object entity, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return this.attributeLoadedPredicate.test(entity, traversableProperty.getName());
        }

        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return true;
        }
    }
}

