/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.validator.runtime.clockprovider;

import io.quarkus.hibernate.validator.runtime.clockprovider.HibernateValidatorClockProviderSystemZoneIdHolder;
import jakarta.validation.ClockProvider;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;

public class RuntimeReinitializedDefaultClockProvider
implements ClockProvider {
    public static final RuntimeReinitializedDefaultClockProvider INSTANCE = new RuntimeReinitializedDefaultClockProvider();
    private static final RuntimeReinitializedDefaultClock clock = new RuntimeReinitializedDefaultClock();

    private RuntimeReinitializedDefaultClockProvider() {
    }

    public Clock getClock() {
        return clock;
    }

    private static class RuntimeReinitializedDefaultClock
    extends Clock {
        private RuntimeReinitializedDefaultClock() {
        }

        @Override
        public ZoneId getZone() {
            return HibernateValidatorClockProviderSystemZoneIdHolder.SYSTEM_ZONE_ID;
        }

        @Override
        public Clock withZone(ZoneId zone) {
            return Clock.system(zone);
        }

        @Override
        public Instant instant() {
            return Instant.now();
        }
    }
}

