/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.infinispan.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.cache.Cache;
import io.quarkus.cache.infinispan.runtime.InfinispanCacheInfo;
import io.quarkus.cache.runtime.AbstractCache;
import io.quarkus.infinispan.client.runtime.InfinispanClientProducer;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.util.NullValue;
import org.reactivestreams.FlowAdapters;
import org.reactivestreams.Publisher;

public class InfinispanCacheImpl
extends AbstractCache
implements Cache {
    private final RemoteCache remoteCache;
    private final InfinispanCacheInfo cacheInfo;
    private final Map<Object, CompletableFuture> computationResults = new ConcurrentHashMap<Object, CompletableFuture>();
    private final long lifespan;
    private final long maxIdle;

    public InfinispanCacheImpl(InfinispanCacheInfo cacheInfo, RemoteCache remoteCache) {
        this.cacheInfo = cacheInfo;
        this.remoteCache = remoteCache;
        this.lifespan = cacheInfo.lifespan.map(l -> l.toMillis()).orElse(-1L);
        this.maxIdle = cacheInfo.maxIdle.map(m -> m.toMillis()).orElse(-1L);
    }

    public InfinispanCacheImpl(InfinispanCacheInfo cacheInfo, Optional<String> infinispanClientName) {
        this(cacheInfo, InfinispanCacheImpl.determineInfinispanClient(infinispanClientName, cacheInfo.name));
    }

    private static RemoteCache determineInfinispanClient(Optional<String> infinispanCacheName, String cacheName) {
        ArcContainer container = Arc.container();
        InfinispanClientProducer producer = (InfinispanClientProducer)container.instance(InfinispanClientProducer.class, new Annotation[0]).get();
        return producer.getRemoteCache(infinispanCacheName.orElse("<default>"), cacheName);
    }

    public String getName() {
        return Objects.requireNonNullElse(this.cacheInfo.name, "default-infinispan-cache");
    }

    public Object getDefaultKey() {
        return "default-key";
    }

    private Object encodeNull(Object value) {
        return value != null ? value : NullValue.NULL;
    }

    private <T> T decodeNull(Object value) {
        return (T)(value != NullValue.NULL ? value : null);
    }

    public <K, V> Uni<V> get(final K key, final Function<K, V> valueLoader) {
        final Context context = Vertx.currentContext();
        final Executor executor = InfinispanCacheImpl.duplicateContextExecutor(context);
        return Uni.createFrom().completionStage(new Supplier<CompletionStage<V>>(){

            @Override
            public CompletionStage<V> get() {
                return InfinispanCacheImpl.this.remoteCache.getAsync(key);
            }
        }).emitOn(executor).flatMap(v1 -> {
            if (v1 != null) {
                return Uni.createFrom().completionStage(new Supplier<CompletionStage<V>>(){

                    @Override
                    public CompletionStage<V> get() {
                        return CompletableFuture.completedFuture(InfinispanCacheImpl.this.decodeNull(v1));
                    }
                }).emitOn(executor);
            }
            final CompletableFuture resultAsync = new CompletableFuture();
            CompletableFuture computedValue = this.computationResults.putIfAbsent(key, resultAsync);
            if (computedValue != null) {
                return Uni.createFrom().completionStage(computedValue).emitOn(executor);
            }
            if (context != null) {
                return Uni.createFrom().completionStage(new Supplier<CompletionStage<? extends V>>(){

                    @Override
                    public CompletionStage<? extends V> get() {
                        return context.executeBlocking(new Callable<V>(){

                            @Override
                            public V call() throws Exception {
                                return valueLoader.apply(key);
                            }
                        }).toCompletionStage().thenComposeAsync(newValue -> {
                            InfinispanCacheImpl.this.putIfAbsentInInfinispan(key, newValue, resultAsync, executor);
                            return resultAsync;
                        }, executor);
                    }
                });
            }
            Object newValue = valueLoader.apply(key);
            this.putIfAbsentInInfinispan(key, newValue, resultAsync, executor);
            return Uni.createFrom().completionStage(resultAsync).emitOn(executor);
        });
    }

    public <K, V> Uni<V> getAsync(K key, Function<K, Uni<V>> valueLoader) {
        final Context context = Vertx.currentContext();
        Executor executor = InfinispanCacheImpl.duplicateContextExecutor(context);
        return Uni.createFrom().completionStage(this.getFromInfinispanAsync(key, valueLoader, executor)).emitOn(new Executor(){

            @Override
            public void execute(final Runnable command) {
                Context ctx = Vertx.currentContext();
                if (context == null) {
                    if (ctx == null) {
                        command.run();
                    } else {
                        ((ContextInternal)ctx).duplicate().runOnContext((Handler)new Handler<Void>(){

                            public void handle(Void ignored) {
                                command.run();
                            }
                        });
                    }
                } else if (ctx == context) {
                    command.run();
                } else {
                    context.runOnContext((Handler)new Handler<Void>(){

                        public void handle(Void ignored) {
                            command.run();
                        }
                    });
                }
            }
        }).emitOn(executor);
    }

    private static Executor duplicateContextExecutor(final Context context) {
        Executor executor = new Executor(){

            @Override
            public void execute(Runnable r) {
                if (context == null) {
                    r.run();
                } else {
                    context.runOnContext(x -> r.run());
                }
            }
        };
        return executor;
    }

    private <K, V> CompletionStage<V> getFromInfinispanAsync(final K key, final Function<K, Uni<V>> valueLoader, final Executor executor) {
        return ((CompletableFuture)((CompletableFuture)this.remoteCache.getAsync(key).exceptionallyAsync(ex -> ex, executor)).thenApplyAsync(new Function(){

            public Object apply(Object v1) {
                if (v1 != null) {
                    return CompletableFuture.completedFuture(InfinispanCacheImpl.this.decodeNull(v1));
                }
                final CompletableFuture resultAsync = new CompletableFuture();
                CompletableFuture computedValue = InfinispanCacheImpl.this.computationResults.putIfAbsent(key, resultAsync);
                if (computedValue != null) {
                    return computedValue;
                }
                ((Uni)valueLoader.apply(key)).convert().toCompletionStage().whenCompleteAsync(new BiConsumer<V, Throwable>(){

                    @Override
                    public void accept(V newValue, Throwable ex2) {
                        if (ex2 != null) {
                            resultAsync.completeExceptionally(ex2);
                            InfinispanCacheImpl.this.computationResults.remove(key);
                        } else {
                            InfinispanCacheImpl.this.putIfAbsentInInfinispan(key, newValue, resultAsync, executor);
                        }
                    }
                }, executor);
                return resultAsync;
            }
        }, executor)).thenComposeAsync(new Function(){

            public Object apply(Object c) {
                return c;
            }
        }, executor);
    }

    private <K, V> void putIfAbsentInInfinispan(final K key, final V newValue, final CompletableFuture<V> resultAsync, Executor executor) {
        this.remoteCache.putIfAbsentAsync(key, this.encodeNull(newValue), this.lifespan, TimeUnit.MILLISECONDS, this.maxIdle, TimeUnit.MILLISECONDS).whenCompleteAsync(new BiConsumer<Object, Throwable>(){

            @Override
            public void accept(Object existing, Throwable ex) {
                try {
                    if (ex != null) {
                        resultAsync.completeExceptionally(ex);
                    } else if (existing == null) {
                        resultAsync.complete(newValue);
                    } else {
                        resultAsync.complete(InfinispanCacheImpl.this.decodeNull(existing));
                    }
                }
                finally {
                    InfinispanCacheImpl.this.computationResults.remove(key);
                }
            }
        }, executor);
    }

    public Uni<Void> invalidate(final Object key) {
        return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<Void>>(){

            @Override
            public CompletionStage<Void> get() {
                return InfinispanCacheImpl.this.remoteCache.removeAsync(key);
            }
        });
    }

    public Uni<Void> invalidateAll() {
        return Uni.createFrom().completionStage((Supplier)new Supplier<CompletionStage<Void>>(){

            @Override
            public CompletionStage<Void> get() {
                return InfinispanCacheImpl.this.remoteCache.clearAsync();
            }
        });
    }

    public Uni<Void> invalidateIf(Predicate<Object> predicate) {
        Flow.Publisher entriesPublisher = FlowAdapters.toFlowPublisher((Publisher)this.remoteCache.publishEntries("org.infinispan.server.hotrod.HotRodServer$ToEmptyBytesKeyValueFilterConverter", null, null, 512));
        return Uni.createFrom().multi(Multi.createFrom().publisher(entriesPublisher).map(e -> e.getKey()).filter(key -> predicate.test(key)).onItem().call(key -> Uni.createFrom().completionStage((CompletionStage)this.remoteCache.removeAsync(key)))).replaceWithVoid();
    }

    public <T extends Cache> T as(Class<T> type) {
        if (type.getTypeName().equals(InfinispanCacheImpl.class.getTypeName())) {
            return (T)((Object)this);
        }
        throw new IllegalArgumentException("Class type not supported : " + String.valueOf(type));
    }
}

