/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime;

import io.quarkus.arc.Arc;
import io.quarkus.arc.runtime.BeanContainerListener;
import io.quarkus.infinispan.client.runtime.InfinispanClientProducer;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.runtime.annotations.RelaxedValidation;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.util.AnnotationLiteral;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.counter.api.CounterManager;

@Recorder
public class InfinispanRecorder {
    public BeanContainerListener configureInfinispan(@RelaxedValidation Map<String, Properties> properties) {
        return container -> {
            InfinispanClientProducer instance = (InfinispanClientProducer)container.beanInstance(InfinispanClientProducer.class, new Annotation[0]);
            instance.setProperties(properties);
        };
    }

    public Supplier<RemoteCacheManager> infinispanClientSupplier(final String clientName) {
        return new InfinispanClientSupplier<RemoteCacheManager>(new Function<InfinispanClientProducer, RemoteCacheManager>(){

            @Override
            public RemoteCacheManager apply(InfinispanClientProducer infinispanClientProducer) {
                return infinispanClientProducer.getNamedRemoteCacheManager(clientName);
            }
        });
    }

    public Supplier<CounterManager> infinispanCounterManagerSupplier(final String clientName) {
        return new InfinispanClientSupplier<CounterManager>(new Function<InfinispanClientProducer, CounterManager>(){

            @Override
            public CounterManager apply(InfinispanClientProducer infinispanClientProducer) {
                return infinispanClientProducer.getNamedCounterManager(clientName);
            }
        });
    }

    public <K, V> Supplier<RemoteCache<K, V>> infinispanRemoteCacheClientSupplier(final String clientName, final String cacheName) {
        return new InfinispanClientSupplier<RemoteCache<K, V>>(new Function<InfinispanClientProducer, RemoteCache<K, V>>(){

            @Override
            public RemoteCache<K, V> apply(InfinispanClientProducer infinispanClientProducer) {
                return infinispanClientProducer.getRemoteCache(clientName, cacheName);
            }
        });
    }

    public RuntimeValue<RemoteCacheManager> getClient(String name) {
        return new RuntimeValue((Object)((RemoteCacheManager)Arc.container().instance(RemoteCacheManager.class, new Annotation[]{this.literal(name)}).get()));
    }

    private AnnotationLiteral literal(String name) {
        if (name.startsWith("<default>")) {
            return Default.Literal.INSTANCE;
        }
        return NamedLiteral.of((String)name);
    }

    static final class InfinispanClientSupplier<T>
    implements Supplier<T> {
        private final Function<InfinispanClientProducer, T> producer;

        InfinispanClientSupplier(Function<InfinispanClientProducer, T> producer) {
            this.producer = producer;
        }

        @Override
        public T get() {
            InfinispanClientProducer infinispanClientProducer = (InfinispanClientProducer)Arc.container().instance(InfinispanClientProducer.class, new Annotation[0]).get();
            return this.producer.apply(infinispanClientProducer);
        }
    }
}

