/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime.cache;

import io.smallrye.mutiny.Uni;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.CacheException;

public class InfinispanGetWrapper {
    final RemoteCache cache;
    final Map<Object, CompletableFuture<Object>> synchronousGets;

    public InfinispanGetWrapper(RemoteCache cache, Map<Object, CompletableFuture<Object>> synchronousGetLocks) {
        this.cache = cache;
        this.synchronousGets = synchronousGetLocks;
    }

    public <K, V> Uni<V> get(final K key, final Function<K, V> valueLoader) {
        return Uni.createFrom().completionStage(new Supplier<CompletionStage<V>>(){

            @Override
            public CompletionStage<V> get() {
                CompletableFuture<Object> infinispanValue = InfinispanGetWrapper.this.getFromInfinispan(key, valueLoader);
                return (CompletionStage)InfinispanGetWrapper.this.cast(infinispanValue);
            }
        });
    }

    private <K, V> CompletableFuture<Object> getFromInfinispan(K key, Function<K, V> valueLoader) {
        CompletableFuture<Object> stage = new CompletableFuture<Object>();
        try {
            CompletableFuture<Object> prev = this.synchronousGets.putIfAbsent(key, stage);
            if (prev != null) {
                return prev;
            }
            this.cache.getAsync(key).whenComplete((valGet, tGet) -> {
                if (tGet != null) {
                    stage.completeExceptionally((Throwable)tGet);
                    this.synchronousGets.remove(key);
                } else if (valGet != null) {
                    stage.complete(valGet);
                    this.synchronousGets.remove(key);
                } else {
                    Object newValue = valueLoader.apply(key);
                    if (newValue == null) {
                        this.synchronousGets.remove(key);
                        stage.complete(null);
                    } else {
                        this.cache.putIfAbsentAsync(key, newValue).whenComplete((valPut, tPut) -> {
                            if (tPut != null) {
                                stage.completeExceptionally((Throwable)tPut);
                            } else {
                                stage.complete(valPut == null ? newValue : valPut);
                            }
                            this.synchronousGets.remove(key);
                        });
                    }
                }
            });
        }
        catch (Exception ex) {
            stage.completeExceptionally(ex);
            this.synchronousGets.remove(key);
        }
        return stage;
    }

    private <T> T cast(Object value) {
        try {
            return (T)value;
        }
        catch (ClassCastException e) {
            throw new CacheException("An existing cached value type does not match the type returned by the value loading function", (Throwable)e);
        }
    }
}

