/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime;

import io.quarkus.kubernetes.service.binding.runtime.ServiceBinding;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConfigSource;
import io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.sshd.common.util.GenericUtils;
import org.jboss.logging.Logger;

public class InfinispanServiceBindingConverter
implements ServiceBindingConverter {
    private static final Logger LOGGER = Logger.getLogger(InfinispanServiceBindingConverter.class);
    private static final String BINDING_TYPE = "infinispan";
    public static final String BINDING_CONFIG_SOURCE_NAME = "infinispan-k8s-service-binding-source";
    public static final String INFINISPAN_URI = "uri";
    public static final String INFINISPAN_HOSTS = "hosts";
    public static final String INFINISPAN_USE_AUTH = "useauth";
    public static final String INFINISPAN_USERNAME = "username";
    public static final String INFINISPAN_PASSWORD = "password";
    public static final String INFINISPAN_CLIENT_URI = "quarkus.infinispan-client.uri";
    public static final String INFINISPAN_CLIENT_HOSTS = "quarkus.infinispan-client.hosts";
    public static final String INFINISPAN_CLIENT_USE_AUTH = "quarkus.infinispan-client.use-auth";
    public static final String INFINISPAN_CLIENT_AUTH_USERNAME = "quarkus.infinispan-client.username";
    public static final String INFINISPAN_CLIENT_AUTH_PASSWORD = "quarkus.infinispan-client.password";

    public Optional<ServiceBindingConfigSource> convert(List<ServiceBinding> serviceBindings) {
        Optional matchingByType = ServiceBinding.singleMatchingByType((String)BINDING_TYPE, serviceBindings);
        if (matchingByType.isEmpty()) {
            return Optional.empty();
        }
        ServiceBinding binding = (ServiceBinding)matchingByType.get();
        HashMap<String, String> properties = new HashMap<String, String>();
        this.setUri(binding, properties);
        this.setConnection(binding, properties);
        this.setUseAuth(binding, properties);
        this.setUsername(binding, properties);
        this.setPassword(binding, properties);
        return Optional.of(new ServiceBindingConfigSource(BINDING_CONFIG_SOURCE_NAME, properties));
    }

    private void setUri(ServiceBinding binding, Map<String, String> properties) {
        properties.put(INFINISPAN_CLIENT_URI, this.getInfinispanProperty(binding, INFINISPAN_URI));
    }

    private void setConnection(ServiceBinding binding, Map<String, String> properties) {
        properties.put(INFINISPAN_CLIENT_HOSTS, this.getInfinispanProperty(binding, INFINISPAN_HOSTS));
    }

    private void setUseAuth(ServiceBinding binding, Map<String, String> properties) {
        properties.put(INFINISPAN_CLIENT_USE_AUTH, this.getInfinispanProperty(binding, INFINISPAN_USE_AUTH));
    }

    private void setUsername(ServiceBinding binding, Map<String, String> properties) {
        properties.put(INFINISPAN_CLIENT_AUTH_USERNAME, this.getInfinispanProperty(binding, INFINISPAN_USERNAME));
    }

    private void setPassword(ServiceBinding binding, Map<String, String> properties) {
        properties.put(INFINISPAN_CLIENT_AUTH_PASSWORD, this.getInfinispanProperty(binding, INFINISPAN_PASSWORD));
    }

    private String getInfinispanProperty(ServiceBinding binding, String infinispanPropertyKey) {
        String infinispanPropertyValue = (String)binding.getProperties().get(infinispanPropertyKey);
        if (GenericUtils.isBlank((CharSequence)infinispanPropertyValue)) {
            LOGGER.debug((Object)String.format("Property '%s' not found", infinispanPropertyKey));
        }
        return infinispanPropertyValue;
    }
}

