/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.infinispan.client.runtime.devui;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.Unremovable;
import io.quarkus.arc.profile.IfBuildProfile;
import io.quarkus.infinispan.client.InfinispanClientName;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;

@IfBuildProfile(value="dev")
@Unremovable
@Singleton
public class InfinispanClientsContainer {
    public List<InfinispanClientInfo> clientsInfo() {
        List instanceHandles = Arc.container().listAll(RemoteCacheManager.class, new Annotation[0]);
        ArrayList<InfinispanClientInfo> infinispanClientInfos = new ArrayList<InfinispanClientInfo>();
        for (InstanceHandle ih : instanceHandles) {
            InjectableBean bean = ih.getBean();
            Set annotationSet = bean.getQualifiers();
            String identifier = "<default>";
            for (Annotation annotation : annotationSet) {
                if (!(annotation instanceof InfinispanClientName)) continue;
                identifier = ((InfinispanClientName)annotation).value();
            }
            List servers = ((RemoteCacheManager)ih.get()).getConfiguration().servers();
            if (servers.isEmpty()) continue;
            ServerConfiguration firstServer = (ServerConfiguration)servers.get(0);
            infinispanClientInfos.add(new InfinispanClientInfo(identifier, firstServer.host() + ":" + firstServer.port()));
        }
        return infinispanClientInfos;
    }

    public static class InfinispanClientInfo {
        public String name;
        public String serverUrl;

        public InfinispanClientInfo(String clientName, String serverUrl) {
            this.name = clientName;
            this.serverUrl = serverUrl;
        }
    }
}

