/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaeger.runtime;

import io.jaegertracing.internal.JaegerSpanContext;
import io.opentracing.Scope;
import io.opentracing.Span;
import org.jboss.logging.MDC;

public class MDCScope
implements Scope {
    private static final String TRACE_ID = "traceId";
    private static final String SPAN_ID = "spanId";
    private static final String PARENT_ID = "parentId";
    private static final String SAMPLED = "sampled";
    private final Scope wrapped;
    private final Object originalTraceId;
    private final Object originalSpanId;
    private final Object originalParentId;
    private final Object originalSampled;

    public MDCScope(Scope scope, Span span) {
        this.wrapped = scope;
        this.originalTraceId = MDC.get((String)TRACE_ID);
        this.originalSpanId = MDC.get((String)SPAN_ID);
        this.originalParentId = MDC.get((String)PARENT_ID);
        this.originalSampled = MDC.get((String)SAMPLED);
        if (span.context() instanceof JaegerSpanContext) {
            this.putContext((JaegerSpanContext)span.context());
        }
    }

    public void close() {
        this.wrapped.close();
        MDC.remove((String)TRACE_ID);
        MDC.remove((String)SPAN_ID);
        MDC.remove((String)PARENT_ID);
        MDC.remove((String)SAMPLED);
        if (this.originalTraceId != null) {
            MDC.put((String)TRACE_ID, (Object)this.originalTraceId);
        }
        if (this.originalSpanId != null) {
            MDC.put((String)SPAN_ID, (Object)this.originalSpanId);
        }
        if (this.originalParentId != null) {
            MDC.put((String)PARENT_ID, (Object)this.originalParentId);
        }
        if (this.originalSampled != null) {
            MDC.put((String)SAMPLED, (Object)this.originalSampled);
        }
    }

    protected void putContext(JaegerSpanContext spanContext) {
        MDC.put((String)TRACE_ID, (Object)spanContext.getTraceId());
        MDC.put((String)SPAN_ID, (Object)Long.toHexString(spanContext.getSpanId()));
        MDC.put((String)PARENT_ID, (Object)Long.toHexString(spanContext.getParentId()));
        MDC.put((String)SAMPLED, (Object)Boolean.toString(spanContext.isSampled()));
    }
}

