/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jaxrs.client.reactive.runtime;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

public abstract class RestClientBase
implements Closeable {
    private final List<ParamConverterProvider> paramConverterProviders;
    private final Map<Class<?>, ParamConverterProvider> providerForClass = new ConcurrentHashMap();
    private static final ParamConverterProvider NO_PROVIDER = new ParamConverterProvider(){

        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            return null;
        }
    };

    public RestClientBase(List<ParamConverterProvider> providers) {
        this.paramConverterProviders = providers;
    }

    public <T> Object[] convertParamArray(T[] value, Class<T> type, Supplier<Type[]> genericType, Supplier<Annotation[][]> methodAnnotations, int paramIndex) {
        ParamConverter<T> converter = this.getConverter(type, genericType, methodAnnotations, paramIndex);
        if (converter == null) {
            return value;
        }
        Object[] result = new Object[value.length];
        for (int i = 0; i < value.length; ++i) {
            result[i] = converter.toString(value[i]);
        }
        return result;
    }

    public <T> Object convertParam(T value, Class<T> type, Supplier<Type[]> genericType, Supplier<Annotation[][]> methodAnnotations, int paramIndex) {
        ParamConverter<T> converter = this.getConverter(type, genericType, methodAnnotations, paramIndex);
        if (converter != null) {
            return converter.toString(value);
        }
        return value;
    }

    private <T> ParamConverter<T> getConverter(Class<T> type, Supplier<Type[]> genericType, Supplier<Annotation[][]> methodAnnotations, int paramIndex) {
        ParamConverterProvider converterProvider = this.providerForClass.get(type);
        if (converterProvider == null) {
            for (ParamConverterProvider provider : this.paramConverterProviders) {
                ParamConverter converter = provider.getConverter(type, genericType.get()[paramIndex], methodAnnotations.get()[paramIndex]);
                if (converter == null) continue;
                this.providerForClass.put(type, provider);
                return converter;
            }
            this.providerForClass.put(type, NO_PROVIDER);
        } else if (converterProvider != NO_PROVIDER) {
            return converterProvider.getConverter(type, genericType.get()[paramIndex], methodAnnotations.get()[paramIndex]);
        }
        return null;
    }
}

