package io.quarkus.test.config;

import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;

import io.quarkus.runtime.LaunchMode;

/**
 * A JUnit {@link LauncherSessionListener}, used to register the initial test config. Test set up code can safely call
 * <code>ConfigProvider.getConfig()</code> to retrieve an instance of the Quarkus configuration.
 * <p>
 * The test config only contains sources known at bootstrap test time. For instance, config sources generated by
 * Quarkus are not available in the test config.
 */
public class ConfigLauncherSession implements LauncherSessionListener {
    @Override
    public void launcherSessionOpened(final LauncherSession session) {
        TestConfigProviderResolver resolver = new TestConfigProviderResolver();
        ConfigProviderResolver.setInstance(resolver);
        resolver.getConfig(LaunchMode.TEST);
    }

    @Override
    public void launcherSessionClosed(final LauncherSession session) {
        ((TestConfigProviderResolver) ConfigProviderResolver.instance()).restore();
    }
}
