/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit.mockito.internal;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.mockito.internal.stubbing.defaultanswers.ReturnsEmptyValues;
import org.mockito.internal.util.JavaEightUtil;
import org.mockito.internal.util.ObjectMethodsGuru;
import org.mockito.internal.util.Primitives;
import org.mockito.invocation.InvocationOnMock;

public class MutinyAnswer
extends ReturnsEmptyValues {
    public Object answer(InvocationOnMock inv) {
        if (ObjectMethodsGuru.isToStringMethod((Method)inv.getMethod()) || ObjectMethodsGuru.isCompareToMethod((Method)inv.getMethod())) {
            return super.answer(inv);
        }
        Class<?> returnType = inv.getMethod().getReturnType();
        if (returnType.getName().equals(Multi.class.getName()) && returnType != Multi.class || returnType.getName().equals(Uni.class.getName()) && returnType != Uni.class) {
            throw new IllegalStateException("Class loader issue: we have two Multi classes with different class loaders. Make sure to initialize this class with the QuarkusClassLoader.");
        }
        if (returnType == Multi.class) {
            return Multi.createFrom().item(this.returnValueForMutiny(inv.getMethod().getGenericReturnType()));
        }
        if (returnType == Uni.class) {
            return Uni.createFrom().item(this.returnValueForMutiny(inv.getMethod().getGenericReturnType()));
        }
        return this.returnValueForClass(returnType);
    }

    private Object returnValueForMutiny(Type uniOrMultiType) {
        if (uniOrMultiType instanceof Class) {
            return this.returnValueForClass(Object.class);
        }
        Type ret = ((ParameterizedType)uniOrMultiType).getActualTypeArguments()[0];
        return this.returnValueForType(ret);
    }

    private Object returnValueForType(Type type) {
        if (type instanceof Class) {
            return this.returnValueForClass((Class)type);
        }
        if (type instanceof ParameterizedType) {
            return this.returnValueForClass((Class)((ParameterizedType)type).getRawType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return this.returnValueForType(tv.getBounds()[0]);
        }
        return this.returnValueForClass(Object.class);
    }

    Object returnValueForClass(Class<?> type) {
        if (Primitives.isPrimitiveOrWrapper(type)) {
            return Primitives.defaultValue(type);
        }
        if (type == Iterable.class) {
            return new ArrayList(0);
        }
        if (type == Collection.class) {
            return new LinkedList();
        }
        if (type == Set.class) {
            return new HashSet();
        }
        if (type == HashSet.class) {
            return new HashSet();
        }
        if (type == SortedSet.class) {
            return new TreeSet();
        }
        if (type == TreeSet.class) {
            return new TreeSet();
        }
        if (type == LinkedHashSet.class) {
            return new LinkedHashSet();
        }
        if (type == List.class) {
            return new LinkedList();
        }
        if (type == LinkedList.class) {
            return new LinkedList();
        }
        if (type == ArrayList.class) {
            return new ArrayList();
        }
        if (type == Map.class) {
            return new HashMap();
        }
        if (type == HashMap.class) {
            return new HashMap();
        }
        if (type == SortedMap.class) {
            return new TreeMap();
        }
        if (type == TreeMap.class) {
            return new TreeMap();
        }
        if (type == LinkedHashMap.class) {
            return new LinkedHashMap();
        }
        if ("java.util.Optional".equals(type.getName())) {
            return JavaEightUtil.emptyOptional();
        }
        if ("java.util.OptionalDouble".equals(type.getName())) {
            return JavaEightUtil.emptyOptionalDouble();
        }
        if ("java.util.OptionalInt".equals(type.getName())) {
            return JavaEightUtil.emptyOptionalInt();
        }
        if ("java.util.OptionalLong".equals(type.getName())) {
            return JavaEightUtil.emptyOptionalLong();
        }
        if ("java.util.stream.Stream".equals(type.getName())) {
            return JavaEightUtil.emptyStream();
        }
        if ("java.util.stream.DoubleStream".equals(type.getName())) {
            return JavaEightUtil.emptyDoubleStream();
        }
        if ("java.util.stream.IntStream".equals(type.getName())) {
            return JavaEightUtil.emptyIntStream();
        }
        if ("java.util.stream.LongStream".equals(type.getName())) {
            return JavaEightUtil.emptyLongStream();
        }
        return null;
    }
}

