/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.logging.InitialConfigurator;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.test.junit.IntegrationTestUtil;
import io.smallrye.config.SmallRyeConfig;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class BasicLoggingEnabler
implements BeforeAllCallback {
    private static final String CFGKEY_ENABLED = "junit.quarkus.enable-basic-logging";
    private static Boolean enabled;
    private static final CompletableFuture<Config> configFuture;
    private static final boolean VERBOSE;
    private static final long staticInitStart;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beforeAll(ExtensionContext context) {
        Config configToRestore;
        Config testConfig;
        long beforeAllStart;
        if (enabled == null) {
            enabled = context.getConfigurationParameter(CFGKEY_ENABLED).map(Boolean::valueOf).orElse(Boolean.TRUE);
        }
        if (!enabled.booleanValue() || InitialConfigurator.DELAYED_HANDLER.isActivated()) {
            return;
        }
        long l = beforeAllStart = VERBOSE ? System.currentTimeMillis() : 0L;
        if (VERBOSE) {
            System.out.printf("BasicLoggingEnabler took %s ms from static init to start of beforeAll()%n", beforeAllStart - staticInitStart);
        }
        try {
            testConfig = configFuture.get();
            if (testConfig == null) {
                testConfig = BasicLoggingEnabler.buildConfig();
            }
        }
        catch (Exception e) {
            System.err.printf("BasicLoggingEnabler failed to retrieve config: %s%n", e instanceof ExecutionException ? ((ExecutionException)e).getCause() : e);
            if (VERBOSE) {
                e.printStackTrace();
            }
            return;
        }
        ConfigProviderResolver configProviderResolver = ConfigProviderResolver.instance();
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            configProviderResolver.registerConfig(testConfig, tccl);
            configToRestore = null;
        }
        catch (IllegalStateException e) {
            if (VERBOSE) {
                System.out.println("BasicLoggingEnabler is swapping config after " + String.valueOf(e));
            }
            configToRestore = configProviderResolver.getConfig();
            configProviderResolver.releaseConfig(configToRestore);
            configProviderResolver.registerConfig(testConfig, tccl);
        }
        try {
            IntegrationTestUtil.activateLogging();
        }
        catch (RuntimeException e) {
            System.err.println("BasicLoggingEnabler failed to enable basic logging: " + String.valueOf(e));
            if (VERBOSE) {
                e.printStackTrace();
            }
        }
        finally {
            configProviderResolver.releaseConfig(testConfig);
            if (configToRestore != null) {
                configProviderResolver.registerConfig(configToRestore, tccl);
            }
        }
        if (VERBOSE) {
            System.out.printf("BasicLoggingEnabler took %s ms from start of beforeAll() to end%n", System.currentTimeMillis() - beforeAllStart);
        }
    }

    private static Config buildConfig() {
        LaunchMode.set((LaunchMode)LaunchMode.TEST);
        long start = VERBOSE ? System.currentTimeMillis() : 0L;
        SmallRyeConfig testConfig = ConfigUtils.configBuilder((boolean)true, (boolean)true, (LaunchMode)LaunchMode.NORMAL).build();
        if (VERBOSE) {
            System.out.printf("BasicLoggingEnabler took %s ms to load config%n", System.currentTimeMillis() - start);
            testConfig.getConfigSources().forEach(s -> System.out.println("BasicLoggingEnabler ConfigSource: " + String.valueOf(s)));
        }
        return testConfig;
    }

    static {
        VERBOSE = Boolean.getBoolean(BasicLoggingEnabler.class.getName() + ".verbose");
        staticInitStart = VERBOSE ? System.currentTimeMillis() : 0L;
        configFuture = !InitialConfigurator.DELAYED_HANDLER.isActivated() && Boolean.parseBoolean(System.getProperty(CFGKEY_ENABLED, "true")) ? CompletableFuture.supplyAsync(BasicLoggingEnabler::buildConfig) : CompletableFuture.completedFuture(null);
    }
}

