/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.utils.BuildToolHelper;
import io.quarkus.bootstrap.workspace.ArtifactSources;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.logging.LoggingSetupRecorder;
import io.quarkus.test.common.ArtifactLauncher;
import io.quarkus.test.common.LauncherUtil;
import io.quarkus.test.common.PathTestHelper;
import io.quarkus.test.common.TestClassIndexer;
import io.quarkus.test.common.TestResourceManager;
import io.quarkus.test.common.http.TestHTTPResourceManager;
import io.quarkus.test.junit.NativeDevServicesHandler;
import io.quarkus.test.junit.QuarkusTestExtensionState;
import io.quarkus.test.junit.QuarkusTestProfile;
import io.quarkus.test.junit.TestProfile;
import io.quarkus.test.junit.TestProfileAndProperties;
import jakarta.enterprise.inject.Alternative;
import jakarta.inject.Inject;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.CodeSource;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RandomStringUtils;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.jandex.Index;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.JUnitException;

public final class IntegrationTestUtil {
    public static final int DEFAULT_PORT = 8081;
    public static final int DEFAULT_HTTPS_PORT = 8444;

    private IntegrationTestUtil() {
    }

    static void ensureNoInjectAnnotationIsUsed(Class<?> testClass) {
        Class<?> current = testClass;
        while (current.getSuperclass() != null) {
            for (Field field : current.getDeclaredFields()) {
                if (field.getAnnotation(Inject.class) != null) {
                    throw new JUnitException("@Inject is not supported in @QuarkusIntegrationTest tests. Offending field is " + field.getDeclaringClass().getTypeName() + "." + field.getName());
                }
                if (field.getAnnotation(ConfigProperty.class) == null) continue;
                throw new JUnitException("@ConfigProperty is not supported in @QuarkusIntegrationTest tests. Offending field is " + field.getDeclaringClass().getTypeName() + "." + field.getName());
            }
            current = current.getSuperclass();
        }
    }

    static Class<? extends QuarkusTestProfile> findProfile(Class<?> testClass) {
        while (testClass != Object.class) {
            TestProfile annotation = testClass.getAnnotation(TestProfile.class);
            if (annotation != null) {
                return annotation.value();
            }
            testClass = testClass.getSuperclass();
        }
        return null;
    }

    static void doProcessTestInstance(Object testInstance, ExtensionContext context) {
        TestHTTPResourceManager.inject((Object)testInstance);
        ExtensionContext root = context.getRoot();
        ExtensionContext.Store store = root.getStore(ExtensionContext.Namespace.GLOBAL);
        QuarkusTestExtensionState state = (QuarkusTestExtensionState)store.get((Object)QuarkusTestExtensionState.class.getName(), QuarkusTestExtensionState.class);
        Closeable testResourceManager = state.testResourceManager;
        if (!(testResourceManager instanceof TestResourceManager)) {
            throw new RuntimeException("An unexpected situation occurred while trying to instantiate the testing infrastructure. Have you perhaps mixed @QuarkusTest and @QuarkusIntegrationTest in the same test run?");
        }
        ((TestResourceManager)state.testResourceManager).inject(testInstance);
    }

    static Map<String, String> getSysPropsToRestore() {
        HashMap<String, String> sysPropRestore = new HashMap<String, String>();
        sysPropRestore.put(LaunchMode.DEVELOPMENT.getProfileKey(), System.getProperty(LaunchMode.TEST.getProfileKey()));
        return sysPropRestore;
    }

    static TestProfileAndProperties determineTestProfileAndProperties(Class<? extends QuarkusTestProfile> profile, Map<String, String> sysPropRestore) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        HashMap<String, String> properties = new HashMap<String, String>();
        QuarkusTestProfile testProfile = null;
        if (profile != null) {
            String configProfile;
            testProfile = profile.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            properties.putAll(testProfile.getConfigOverrides());
            Set<Class<?>> enabledAlternatives = testProfile.getEnabledAlternatives();
            if (!enabledAlternatives.isEmpty()) {
                properties.put("quarkus.arc.selected-alternatives", enabledAlternatives.stream().peek(c -> {
                    if (!c.isAnnotationPresent(Alternative.class)) {
                        throw new RuntimeException("Enabled alternative " + c + " is not annotated with @Alternative");
                    }
                }).map(Class::getName).collect(Collectors.joining(",")));
            }
            if ((configProfile = testProfile.getConfigProfile()) != null) {
                properties.put(LaunchMode.NORMAL.getProfileKey(), configProfile);
            }
            properties.put("quarkus.configuration.build-time-mismatch-at-runtime", "fail");
            for (Map.Entry i : properties.entrySet()) {
                sysPropRestore.put((String)i.getKey(), System.getProperty((String)i.getKey()));
            }
            for (Map.Entry i : properties.entrySet()) {
                System.setProperty((String)i.getKey(), (String)i.getValue());
            }
        }
        return new TestProfileAndProperties(testProfile, properties);
    }

    static void startLauncher(ArtifactLauncher launcher, Map<String, String> additionalProperties, Runnable sslSetter) throws IOException {
        launcher.includeAsSysProps(additionalProperties);
        try {
            launcher.start();
        }
        catch (IOException e) {
            try {
                launcher.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw e;
        }
        if (launcher.listensOnSsl() && sslSetter != null) {
            sslSetter.run();
        }
    }

    static ArtifactLauncher.InitContext.DevServicesLaunchResult handleDevServices(ExtensionContext context, boolean isDockerAppLaunch) throws Exception {
        Class requiredTestClass = context.getRequiredTestClass();
        Path testClassLocation = PathTestHelper.getTestClassesLocation((Class)requiredTestClass);
        Path appClassLocation = PathTestHelper.getAppClassLocationForTestLocation((String)testClassLocation.toString());
        PathList.Builder rootBuilder = PathList.builder();
        if (!appClassLocation.equals(testClassLocation)) {
            rootBuilder.add(testClassLocation);
            Path testResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)testClassLocation, (String)"test");
            if (testResourcesLocation != null) {
                rootBuilder.add(testResourcesLocation);
            }
        }
        QuarkusBootstrap.Builder runnerBuilder = QuarkusBootstrap.builder().setIsolateDeployment(true).setMode(QuarkusBootstrap.Mode.TEST);
        Path projectRoot = Paths.get("", new String[0]).normalize().toAbsolutePath();
        runnerBuilder.setProjectRoot(projectRoot);
        runnerBuilder.setTargetDirectory(PathTestHelper.getProjectBuildDir((Path)projectRoot, (Path)testClassLocation));
        rootBuilder.add(appClassLocation);
        Path appResourcesLocation = PathTestHelper.getResourcesForClassesDirOrNull((Path)appClassLocation, (String)"main");
        if (appResourcesLocation != null) {
            rootBuilder.add(appResourcesLocation);
        }
        if (System.getProperty("quarkus-internal-test.serialized-app-model.path") == null) {
            ApplicationModel model = BuildToolHelper.enableGradleAppModelForTest((Path)projectRoot);
            if (model != null && model.getApplicationModule() != null) {
                Path classes;
                ArtifactSources testSources = model.getApplicationModule().getTestSources();
                if (testSources != null) {
                    for (SourceDir src : testSources.getSourceDirs()) {
                        if (Files.exists(src.getOutputDir(), new LinkOption[0]) || rootBuilder.contains(classes = src.getOutputDir())) continue;
                        rootBuilder.add(classes);
                    }
                }
                for (SourceDir src : model.getApplicationModule().getMainSources().getSourceDirs()) {
                    if (Files.exists(src.getOutputDir(), new LinkOption[0]) || rootBuilder.contains(classes = src.getOutputDir())) continue;
                    rootBuilder.add(classes);
                }
            }
        } else if (System.getProperty("OUTPUT_SOURCES_DIR") != null) {
            ArtifactSources sourceDirectories;
            for (ArtifactSources sourceDirectory : sourceDirectories = System.getProperty("OUTPUT_SOURCES_DIR").split(",")) {
                Path directory = Paths.get((String)sourceDirectory, new String[0]);
                if (!Files.exists(directory, new LinkOption[0]) || rootBuilder.contains(directory)) continue;
                rootBuilder.add(directory);
            }
        }
        runnerBuilder.setApplicationRoot((PathCollection)rootBuilder.build());
        CuratedApplication curatedApplication = runnerBuilder.setTest(true).build().bootstrap();
        Index testClassesIndex = TestClassIndexer.indexTestClasses((Class)requiredTestClass);
        TestClassIndexer.writeIndex((Index)testClassesIndex, (Class)requiredTestClass);
        final HashMap<String, String> propertyMap = new HashMap<String, String>();
        Object networkId = null;
        AugmentAction augmentAction = isDockerAppLaunch ? curatedApplication.createAugmentor("io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem$Factory", Map.of("source", "io.quarkus.test.junit")) : curatedApplication.createAugmentor();
        augmentAction.performCustomBuild(NativeDevServicesHandler.class.getName(), (Object)new BiConsumer<String, String>(){

            @Override
            public void accept(String s, String s2) {
                propertyMap.put(s, s2);
            }
        }, new String[]{DevServicesLauncherConfigResultBuildItem.class.getName()});
        boolean manageNetwork = false;
        if (isDockerAppLaunch) {
            try {
                Class networkClass = curatedApplication.getOrCreateAugmentClassLoader().loadClass("org.testcontainers.containers.Network");
                Object sharedNetwork = networkClass.getField("SHARED").get(null);
                networkId = (String)networkClass.getMethod("getId", new Class[0]).invoke(sharedNetwork, new Object[0]);
            }
            catch (Exception e) {
                Config config = LauncherUtil.installAndGetSomeConfig();
                Optional networkIdOpt = config.getOptionalValue("quarkus.test.container.network", String.class);
                if (networkIdOpt.isPresent()) {
                    networkId = (String)networkIdOpt.get();
                }
                networkId = "quarkus-integration-test-" + RandomStringUtils.insecure().next(5, true, false);
                manageNetwork = true;
            }
        }
        DefaultDevServicesLaunchResult result = new DefaultDevServicesLaunchResult((Map<String, String>)propertyMap, (String)networkId, manageNetwork, curatedApplication);
        IntegrationTestUtil.createNetworkIfNecessary(result);
        return result;
    }

    private static void createNetworkIfNecessary(final ArtifactLauncher.InitContext.DevServicesLaunchResult devServicesLaunchResult) {
        if (devServicesLaunchResult.manageNetwork() && devServicesLaunchResult.networkId() != null) {
            final ContainerRuntimeUtil.ContainerRuntime containerRuntime = ContainerRuntimeUtil.detectContainerRuntime((boolean)true, (ContainerRuntimeUtil.ContainerRuntime[])new ContainerRuntimeUtil.ContainerRuntime[0]);
            try {
                int networkCreateResult = new ProcessBuilder(new String[0]).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).command(containerRuntime.getExecutableName(), "network", "create", devServicesLaunchResult.networkId()).start().waitFor();
                if (networkCreateResult > 0) {
                    throw new RuntimeException("Creating container network '" + devServicesLaunchResult.networkId() + "' completed unsuccessfully");
                }
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            new ProcessBuilder(new String[0]).redirectError(ProcessBuilder.Redirect.DISCARD).redirectOutput(ProcessBuilder.Redirect.DISCARD).command(containerRuntime.getExecutableName(), "network", "rm", devServicesLaunchResult.networkId()).start().waitFor();
                        }
                        catch (IOException | InterruptedException ignored) {
                            System.out.println("Unable to delete container network '" + devServicesLaunchResult.networkId() + "'");
                        }
                    }
                }));
            }
            catch (Exception e) {
                throw new RuntimeException("Creating container network '" + devServicesLaunchResult.networkId() + "' completed unsuccessfully");
            }
        }
    }

    static void activateLogging() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> lrs = cl.loadClass(LoggingSetupRecorder.class.getName());
            lrs.getDeclaredMethod("handleFailedStart", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Properties readQuarkusArtifactProperties(ExtensionContext context) {
        Properties properties;
        Path buildOutputDirectory = IntegrationTestUtil.determineBuildOutputDirectory(context);
        Path artifactProperties = buildOutputDirectory.resolve("quarkus-artifact.properties");
        if (!Files.exists(artifactProperties, new LinkOption[0])) {
            TestLauncher testLauncher = IntegrationTestUtil.determineTestLauncher();
            Object errorMessage = "Unable to locate the artifact metadata file created that must be created by Quarkus in order to run integration tests. ";
            if (testLauncher == TestLauncher.MAVEN) {
                String testClassName;
                errorMessage = (String)errorMessage + "Make sure this test is run after 'mvn package'. ";
                if (context.getTestClass().isPresent() && (testClassName = ((Class)context.getTestClass().get()).getName()).endsWith("Test")) {
                    errorMessage = (String)errorMessage + "The easiest way to ensure this is by having the 'maven-failsafe-plugin' run the test instead of the 'maven-surefire-plugin'.";
                }
            } else {
                errorMessage = testLauncher == TestLauncher.GRADLE ? (String)errorMessage + "Make sure this test is run after the 'quarkusBuild' Gradle task." : (String)errorMessage + "Make sure this test is run after the Quarkus artifact is built from your build tool.";
            }
            throw new IllegalStateException((String)errorMessage);
        }
        Properties properties2 = new Properties();
        FileInputStream fis = new FileInputStream(artifactProperties.toFile());
        try {
            properties2.load(fis);
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to read artifact metadata file created that must be created by Quarkus in order to run integration tests.", e);
            }
        }
        fis.close();
        return properties;
    }

    static String getArtifactType(Properties quarkusArtifactProperties) {
        String artifactType = quarkusArtifactProperties.getProperty("type");
        if (artifactType == null) {
            throw new IllegalStateException("Unable to determine the type of artifact created by the Quarkus build");
        }
        return artifactType;
    }

    private static TestLauncher determineTestLauncher() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int i = stackTrace.length - 1;
        TestLauncher testLauncher = TestLauncher.UNKNOWN;
        do {
            StackTraceElement element;
            String className;
            if ((className = (element = stackTrace[i--]).getClassName()).startsWith("org.apache.maven")) {
                testLauncher = TestLauncher.MAVEN;
                break;
            }
            if (!className.startsWith("org.gradle")) continue;
            testLauncher = TestLauncher.GRADLE;
        } while (i != 0);
        return testLauncher;
    }

    static Path determineBuildOutputDirectory(ExtensionContext context) {
        String buildOutputDirStr = System.getProperty("build.output.directory");
        Path result = null;
        if (buildOutputDirStr != null) {
            result = Paths.get(buildOutputDirStr, new String[0]);
        } else {
            Class testClass = context.getRequiredTestClass();
            CodeSource codeSource = testClass.getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                URL codeSourceLocation = codeSource.getLocation();
                Path artifactPropertiesDirectory = IntegrationTestUtil.determineBuildOutputDirectory(codeSourceLocation);
                if (artifactPropertiesDirectory == null) {
                    throw new IllegalStateException("Unable to determine the output of the Quarkus build. Consider setting the 'build.output.directory' system property.");
                }
                result = artifactPropertiesDirectory;
            }
        }
        if (result == null) {
            throw new IllegalStateException("Unable to locate the artifact metadata file created that must be created by Quarkus in order to run tests annotated with '@QuarkusIntegrationTest'.");
        }
        if (!Files.isDirectory(result, new LinkOption[0])) {
            throw new IllegalStateException("The determined Quarkus build output '" + result.toAbsolutePath().toString() + "' is not a directory");
        }
        return result;
    }

    private static Path determineBuildOutputDirectory(URL url) {
        if (url == null) {
            return null;
        }
        if (url.getProtocol().equals("file")) {
            if (url.getPath().endsWith("test-classes/")) {
                return IntegrationTestUtil.toPath(url).getParent();
            }
            if (url.getPath().endsWith("test/") || url.getPath().endsWith("integrationTest/")) {
                return IntegrationTestUtil.toPath(url).getParent().getParent().getParent();
            }
            if (url.getPath().contains("/target/surefire/")) {
                String path = url.getPath();
                int index = path.lastIndexOf("/target/");
                try {
                    return Paths.get(new URI("file:" + path.substring(0, index) + "/target/"));
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
            if (url.getPath().endsWith("-tests.jar")) {
                Path baseDir = Path.of("", new String[0]).normalize().toAbsolutePath();
                Path outputDir = baseDir.resolve("target");
                if (Files.exists(outputDir, new LinkOption[0])) {
                    return outputDir;
                }
                outputDir = baseDir.resolve("build");
                if (Files.exists(outputDir, new LinkOption[0])) {
                    return outputDir;
                }
            }
        }
        return null;
    }

    private static Path toPath(URL url) {
        try {
            return Paths.get(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    static class DefaultDevServicesLaunchResult
    implements ArtifactLauncher.InitContext.DevServicesLaunchResult {
        private final Map<String, String> properties;
        private final String networkId;
        private final boolean manageNetwork;
        private final CuratedApplication curatedApplication;

        DefaultDevServicesLaunchResult(Map<String, String> properties, String networkId, boolean manageNetwork, CuratedApplication curatedApplication) {
            this.properties = properties;
            this.networkId = networkId;
            this.manageNetwork = manageNetwork;
            this.curatedApplication = curatedApplication;
        }

        public Map<String, String> properties() {
            return this.properties;
        }

        public String networkId() {
            return this.networkId;
        }

        public boolean manageNetwork() {
            return this.manageNetwork;
        }

        public CuratedApplication getCuratedApplication() {
            return this.curatedApplication;
        }

        public void close() {
            this.curatedApplication.close();
        }
    }

    private static enum TestLauncher {
        MAVEN,
        GRADLE,
        UNKNOWN;

    }
}

